/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Walker for java.util.Map
 *
 * @author Philipp Meier <meier@o-matic.de>
 * @version $Revision: 1.2 $
 * @see webwork.view.xslt.SAXAdapter.XMLReaderAdapter
 */
public class MapWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value, String attributeName, List walkedInstances)
            throws SAXException
    {
        contentHandler.startElement("", attributeName, "", EMPTY_ATTRS);
        Map map = (Map) value;
        for (Iterator iter = map.entrySet().iterator(); iter.hasNext();)
        {
            Map.Entry entry = (Map.Entry) iter.next();
            rootWalker.walk(contentHandler, entry.getKey(), "key", walkedInstances);
            rootWalker.walk(contentHandler, entry.getValue(), "value", walkedInstances);
        }
        contentHandler.endElement("", attributeName, "");
    }

    public Class getWalkedType()
    {
        return Map.class;
    }
}
