/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

/**
 * Radio button list tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.6 $
 */
public class RadioTag extends AbstractHTMLListTag
{
    protected String checked;

    public void setChecked(String checked)
    {
        this.checked = checked;
    }
    
    // Public --------------------------------------------------------
    public String getTemplate()
    {
        if (!useMap)
        {
            this.addParameter("listValue", findValue("'value'"));
            this.addParameter("listKey", findValue("'key'"));
        }
        if (checked != null)
        {
            this.addParameter("checked", findValue(checked));
        }
        
        return "radiomap";
    }
}