/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * Password field tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.5 $
 */
public class PasswordTag extends TextFieldTag
{
    protected String showPasswordAttr;

    // Public --------------------------------------------------------
    public String getTemplate()
    {
        return "password";
    }

    public void setShow(String aShowPasswordAttr)
    {
        this.showPasswordAttr = aShowPasswordAttr;
    }

    public int doEndTag()
            throws JspException
    {
        if (showPasswordAttr != null)
        {
            this.addParameter("show", findValue(showPasswordAttr));
        }
        else
        {
            this.addParameter("show", Boolean.FALSE);
        }

        return super.doEndTag();
    }

}
