/*
 * Atlassian Source Code Template.
 * User: mike
 * Created: 2/09/2002 19:09:42
 * Time: 4:32:34 PM
 * CVS Revision: $Revision: 1.1 $
 * Last CVS Commit: $Date: 2002/09/02 23:55:31 $
 * Author of last CVS Commit: $Author: cybermike $
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * A tag that all HTML based WW tags should extend. It implements a few HTML attributes. (More could be added later to
 * add them to all tags)
 *
 * @author Mike Cannon-Brookes (mike@atlassian.com)
 * @version $Revision: 1.1 $
 */
public class AbstractHTMLComponentTag extends ComponentTag
{
    protected String disabledAttr;
    protected String tabindexAttr;
    protected String onchangeAttr;

    public void setDisabled(String disabled)
    {
        this.disabledAttr = disabled;
    }

    public void setOnchange(String onchange)
    {
        this.onchangeAttr = onchange;
    }

    public void setTabindex(String tabindex)
    {
        this.tabindexAttr = tabindex;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (disabledAttr != null)
        {
            this.addParameter("disabled", findValue(disabledAttr));
        }
        if (tabindexAttr != null)
        {
            this.addParameter("tabindex", findValue(tabindexAttr));
        }
        if (onchangeAttr != null)
        {
            this.addParameter("onchange", findValue(onchangeAttr));
        }
        return super.doEndTag();
    }
}
