/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.iterator;

import webwork.view.taglib.ActionTag;
import webwork.util.SubsetIteratorFilter;
import webwork.util.SortIteratorFilter;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import java.util.Comparator;

/**
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.2 $
 */
public class SortIteratorTag
        extends ActionTag
{
    // Attributes ----------------------------------------------------
    String sourceAttr;
    String comparatorAttr;

    // Constructor ---------------------------------------------------
    public void setParent(Tag t)
    {
        super.setParent(t);
        setName("'" + SortIteratorFilter.class.getName() + "'");
    }

    // Public --------------------------------------------------------
    public void setSource(String aName)
    {
        sourceAttr = aName;
    }

    public void setComparator(String aComparator)
    {
        comparatorAttr = aComparator;
    }

    public int doStartTag() throws JspException
    {
        super.doStartTag();

        // Pop holder temporarily while we resolve names
        Object holder = getStack().popValue();

        if (sourceAttr == null)
        {
            ((SortIteratorFilter) bean).setSource(findValue("."));
        }
        else
        {
            ((SortIteratorFilter) bean).setSource(findValue(sourceAttr));
        }

        Comparator c = (Comparator) findValue(comparatorAttr);
        ((SortIteratorFilter) bean).setComparator((Comparator) findValue(comparatorAttr));

        // Push holder back on stack
        getStack().pushValue(holder);

        return EVAL_BODY_INCLUDE;
    }
}
