/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

/**
 * This class contains bundle key strings used to look up localized messages for property editor exceptions. These
 * strings are normally passed in to the constructor of PropertyEditorException. The ActionSupport.properties file
 * contains default messages for these keys.
 *
 * @author Dick Zetterberg (dick@transitor.se)
 * @version $Revision: 1.1 $
 * @see PropertyEditorException
 * @see webwork.action.ActionSupport
 */
public class PropertyMessage
{
    public static final String BAD_INTEGER = "BAD_INTEGER";
    public static final String EMPTY_INTEGER = "EMPTY_INTEGER";
    public static final String BAD_INTEGEROBJ = "BAD_INTEGEROBJ";

    public static final String BAD_LONG = "BAD_LONG";
    public static final String EMPTY_LONG = "EMPTY_LONG";
    public static final String BAD_LONGOBJ = "BAD_LONGOBJ";

    public static final String BAD_SHORT = "BAD_SHORT";
    public static final String EMPTY_SHORT = "EMPTY_SHORT";
    public static final String BAD_SHORTOBJ = "BAD_SHORTOBJ";

    public static final String BAD_FLOAT = "BAD_FLOAT";
    public static final String EMPTY_FLOAT = "EMPTY_FLOAT";
    public static final String BAD_FLOATOBJ = "BAD_FLOATOBJ";

    public static final String BAD_DOUBLE = "BAD_DOUBLE";
    public static final String EMPTY_DOUBLE = "EMPTY_DOUBLE";
    public static final String BAD_DOUBLEOBJ = "BAD_DOUBLEOBJ";

    public static final String BAD_BYTE = "BAD_BYTE";
    public static final String EMPTY_BYTE = "EMPTY_BYTE";
    public static final String BAD_BYTEOBJ = "BAD_BYTEOBJ";

    public static final String BAD_BOOLEAN = "BAD_BOOLEAN";
    public static final String EMPTY_BOOLEAN = "EMPTY_BOOLEAN";
    public static final String BAD_BOOLEANOBJ = "BAD_BOOLEANOBJ";

    public static final String BAD_BIGDECIMAL = "BAD_BIGDECIMAL";

    public static final String BAD_DATE = "BAD_DATE";

    public static final String BAD_DATEFORMAT = "BAD_DATEFORMAT";

    public static final String BAD_VALUE = "BAD_VALUE";

}