package webwork.util;

import java.util.Map;
import java.util.StringTokenizer;

/**
 * This class will replace named "variables" inside a string with values from a map.
 * <p/>
 * The syntax is {variableName} and the \ character can be sue to quote any other character including itself.  This
 * means you need to input \\ to output a single \ and \{ to output a {
 * <p/>
 * It does not interpolate results once replaced so if {a} = the string "{b}" it WONT re-interpolate it to be the value of b from the map.
 */
public class StringVariableSubstitutionKit
{
    public static String substitue(String input, Map<String, Object> substitutions)
    {
        if (input == null || input.length() == 0)
        {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, "\\{}", true);
        StringBuilder out = new StringBuilder(input.length());
        StringBuilder variableName = new StringBuilder();
        boolean inVar = false;
        boolean inBackSlash = false;
        boolean inVarBackSlash = false;

        while (st.hasMoreTokens())
        {
            String token = st.nextToken();
            if (inVar)
            {
                if (inVarBackSlash)
                {
                    variableName.append(token);
                    inVarBackSlash = false;
                }
                else if ("\\".equals(token))
                {
                    inVarBackSlash = true;
                }
                else if ("}".equals(token))
                {
                    // end of variable name  now look in the map for a value
                    Object value = substitutions.get(variableName.toString());
                    if (value != null)
                    {
                        out.append(value.toString());
                    } else {
                        // if we have no parameters then we re-insert the variable name back in.  We dont want "user generated" content that
                        // happens to look like {xxx} to be removed if we havent specified a parameter for it
                        out.append("{").append(variableName).append("}");
                    }
                    inVar = false;
                    variableName.setLength(0);
                }
                else
                {
                    variableName.append(token);
                }
            }
            else if (inBackSlash)
            {
                out.append(token);
                inBackSlash = false;
            }
            else
            {
                if ("\\".equals(token))
                {
                    inBackSlash = true;
                }
                else if ("{".equals(token))
                {
                    inVar = true;
                }
                else
                {
                    out.append(token);
                }
            }
        }
        // any left trail like {xxx without closing }
        if (inVar)
        {
            out.append("{"); // reinstate the eaten {
            out.append(variableName);
            if (inVarBackSlash)
            {
                out.append("\\"); // which was eater earlier
            }
        }
        return out.toString();
    }
}
