/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.vxml;

import webwork.action.ActionSupport;

import java.util.List;
import java.util.ArrayList;

/**
 * Simple VXML test.
 *
 * @author Jeff Haynie (jhaynie@vocalocity.net)
 * @version $Revision: 1.1 $
 */
public class VXMLTest extends ActionSupport
{
    // Attributes ----------------------------------------------------

    // Public --------------------------------------------------------

    public class G
    {
        String value;
        String tag;

        public G(String v, String t)
        {
            value = v;
            tag = t;
        }

        public String getValue()
        {
            return value;
        }

        public String getTag()
        {
            return tag;
        }
    }

    public List getGrammar()
    {
        List l = new ArrayList(3);
        l.add(new G("Jeff", "TAG='Jeff Haynie'"));
        l.add(new G("Matt", "TAG='Matt Baldree'"));
        l.add(new G("Rickard", "TAG='Rickard Oberg'"));
        return l;
    }

    // Action implementation -----------------------------------------
    protected String doExecute() throws Exception
    {
        return SUCCESS;
    }

    // Protected -----------------------------------------------------
}
