/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.helloworld;

import webwork.action.ActionSupport;
import webwork.action.CommandDriven;
import webwork.action.SessionAware;

import java.util.Map;

/**
 * Login for the HelloWorld example.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.5 $
 */
public class Login
        extends ActionSupport
        implements SessionAware, CommandDriven
{
    // Attributes ----------------------------------------------------
    String name = "";
    String password = "";

    Map session;

    // Public --------------------------------------------------------
    public void setName(String name)
    {
        this.name = name;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public String getName()
    {
        return name;
    }

    public String getPassword()
    {
        return password;
    }

    // SessionAware implementation ------------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // ActionFormSupport implementation ----------------------------------------
    protected void doValidation()
    {
        // Validate input
        if (name.equals(""))
        {
            addError("name", "Missing name");
        }
        if (password.equals(""))
        {
            addError("password", "Missing password");
        }
    }

    protected String doExecute()
    {
        // Check login
        if (!password.equals(name))
        {
            addErrorMessage("Wrong password");
            return ERROR;
        }

        // Login
        session.put("name", name);

        // Show result
        return SUCCESS;
    }
}
