/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;

import java.util.Properties;

/**
 * This action samples some virtual machine runtime information.
 *
 * @author Philipp Meier (<meier@o-matic.de>)
 * @version $Revision: 1.4 $
 */
public class SystemInfo extends ActionSupport
{
    private long currentTimeMillis;
    private Properties properties;
    private long freeMemory;
    private long totalMemory;

    public long currentTimeMillis()
    {
        return currentTimeMillis;
    }

    public Properties getProperties()
    {
        return properties;
    }

    public long getFreeMemory()
    {
        return freeMemory;
    }

    public long getTotalMemory()
    {
        return totalMemory;
    }

    public long getUsedMemory()
    {
        return totalMemory - freeMemory;
    }

    protected String doExecute()
    {
        properties = System.getProperties();
        currentTimeMillis = System.currentTimeMillis();
        freeMemory = Runtime.getRuntime().freeMemory();
        totalMemory = Runtime.getRuntime().totalMemory();
        return SUCCESS;
    }
}
