/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.util.Enumeration;
import java.util.List;

public class EnumerationWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler,
            Object value, String attributeName, List walkedInstances) throws SAXException
    {
        contentHandler.startElement("", attributeName, "", EMPTY_ATTRS);
        for (Enumeration e = (Enumeration) value; e.hasMoreElements();)
        {
            Object obj = e.nextElement();
            rootWalker.walk(contentHandler, obj, "item", walkedInstances);
        }
        contentHandler.endElement("", attributeName, "");
    }

    public Class getWalkedType()
    {
        return Enumeration.class;
    }
}
