/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.vui;

import org.apache.commons.logging.*;
import webwork.config.Configuration;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import java.util.HashMap;
import java.util.Map;
import java.io.IOException;

/**
 * Voice UI for field tag
 *
 * @author Jeff Haynie (jhaynie@vocalocity.net)
 * @version $Revision: 1.2 $
 */
public class FieldTag
        extends AbstractVUITag
{
    // Attributes ----------------------------------------------------
    protected static Log log = LogFactory.getLog(FieldTag.class);
    protected String nameAttr;
    protected String slotAttr;
    protected String modalAttr;
    protected String condAttr;
    protected String typeAttr;

    // Public --------------------------------------------------------

    public String getHeaderTemplate()
    {
        return "field-header.jsp";
    }

    public String getFooterTemplate()
    {
        return "field-footer.jsp";
    }

    public void setName(String aName)
    {
        nameAttr = aName;
    }

    public void setModal(String aName)
    {
        modalAttr = aName;
    }

    public String getModal()
    {
        return modalAttr;
    }

    public void setSlot(String aName)
    {
        slotAttr = aName;
    }

    public String getSlot()
    {
        return slotAttr;
    }

    public void setCond(String aName)
    {
        condAttr = aName;
    }

    public String getCond()
    {
        return condAttr;
    }

    public void setType(String aName)
    {
        typeAttr = aName;
    }

    public String getType()
    {
        return typeAttr;
    }

    protected void initializeAttributes()
    {
        getSetParameter(nameAttr, "name");
        getSetParameter(condAttr, "cond");
        getSetParameter(modalAttr, "modal");
        getSetParameter(slotAttr, "slot");
        getSetParameter(typeAttr, "type");
    }
}
