package webwork.view.taglib.ui;

/**
 * A class to smart remove quotes around strings 
 */
class QuoteRemover
{
    static String removeSingleQuotes(String s)
    {
        if (s == null || s.length() == 0)
        {
            return s;
        }
        int start = 0;
        int end = s.length()-1;
        if (s.charAt(start) == '\'')
        {
            start++;
        }
        if (s.charAt(end) == '\'')
        {
            end--;
        }
        if (start == end)
        {
            return ""; // all quotes
        }
        return s.substring(start,end+1);
    }
}
