/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.iterator;

import webwork.view.taglib.ActionTag;
import webwork.util.AppendIteratorFilter;

import javax.servlet.jsp.tagext.Tag;

/**
 * Append a list of iterators. The values of the iterators will be merged into one iterator.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.2 $
 */
public class AppendIteratorTag
        extends ActionTag
{
    // Attributes ----------------------------------------------------

    // Constructor ---------------------------------------------------

    public void setParent(Tag t)
    {
        super.setParent(t);
        setName("'" + AppendIteratorFilter.class.getName() + "'");
    }
}
