package webwork.view.taglib;

import webwork.util.BeanUtil;
import webwork.util.StringVariableSubstitutionKit;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;

/**
 * A tag that will write out the string value of a
 */
public class WriteTag extends BasicPropertyTag implements ParamTag.Parametric
{
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();


    /**
     * The write  tag should escape IF the escape value has been set to true, OR if the tag has a body and there is no
     * set escape value.
     * <p/>
     * CHANGE THIS METHOD ON PAIN OF DEATH -mike and now brad :)
     *
     * @see BasicPropertyTag#shouldEscape()
     */
    protected boolean shouldEscape()
    {
        return escape == null || escape;
    }

    public void addParameter(final String name, final Object value)
    {
        if (value == null)
        {
            params.remove(name);
        }
        else
        {
            params.put(name, BeanUtil.toStringValue(value));
        }
    }


    @Override
    public int doStartTag() throws JspException
    {
        return EVAL_BODY_BUFFERED;
    }

    @Override
    public int doAfterBody() throws JspException
    {
        return SKIP_BODY;
    }

    @Override
    public int doEndTag() throws JspException
    {
        Object value = findValue(valueAttr);
        if (isNotBlank(value))
        {
            writeContent(value.toString());
        }
        if (isNotBlank(this.bodyContent))
        {
            String bodyContent = this.bodyContent.getString();
            writeContent(bodyContent);
        }
        return EVAL_PAGE;
    }

    private void writeContent(String bodyContent) throws JspException
    {
        try
        {
            bodyContent = StringVariableSubstitutionKit.substitue(bodyContent, params);
            if (shouldEscape())
            {
                bodyContent = escapeValue(bodyContent);
            }
            pageContext.getOut().write(bodyContent);
        }
        catch (IOException ioe)
        {
            String msg = "Could not show write body content";
            throw new JspException(msg + ", throwable: " + ioe, ioe);
        }
    }

    private boolean isNotBlank(final Object value)
    {
        return value != null && value.toString().length() > 0;
    }
}
