package webwork.view.taglib;

import webwork.util.URLCodec;

/**
 * This tags acts like a property tag except that it uses
 * URL encoding instead of HTML encoding
 *
 */
public class URLEncodeTag extends PropertyTag
{
    @Override
    protected String escapeValue(final String value)
    {
        return URLCodec.encode(value);
    }
}
