/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

/**
 * Access the value of a named property. By default (implicitly), this tag will escape its contents if it does *not*
 * have a body. If it does have a body, the tag will not escape the contents. You can explicitly tell the tag to escape
 * or not. Quoted text that is escaped will have its quotes stripped off.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @author Matt Baldree (matt@smallleap.com)
 * @version $Revision: 1.19 $
 */
public class PropertyTag extends BasicPropertyTag
{
    /**
     * The property tag should escape IF the escape value has been set to true, OR if the tag has a body and there is no
     * set escape value.
     * <p/>
     * CHANGE THIS METHOD ON PAIN OF DEATH -mike :)
     *
     * @see BasicPropertyTag#shouldEscape()
     */
    protected boolean shouldEscape()
    {
        if (hadBody && escape == null)
        {
            return false;
        }

        if (!hadBody && escape == null)
        {
            return true;
        }

        return escape.booleanValue();
    }
}


