/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import org.apache.commons.logging.*;

import javax.servlet.jsp.JspException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.ResourceBundle;
import java.util.MissingResourceException;

import webwork.action.factory.ActionFactory;
import webwork.action.ActionSupport;
import webwork.action.ActionContext;

/**
 * Gets a resource bundle and place it on the value stack. This allows the text tag to access messages from any bundle,
 * and not just the bundle associated with the current action.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.10 $
 */
public class I18nTag
        extends WebWorkTagSupport
{
    // Attributes ----------------------------------------------------
    protected String nameAttr;

    // Public --------------------------------------------------------
    public void setName(String aName)
    {
        nameAttr = aName;
    }

    // BodyTag implementation ----------------------------------------
    public int doStartTag() throws JspException
    {
        // Get bundle
        try
        {
            String name = this.findString(nameAttr);
            ResourceBundle bundle = (ResourceBundle) findValue("texts('" + name + "')");

            if (bundle == null)
            {
                // No bundle found, so most likely no action on stack
                // Get a bundle using the default ActionSupport class
                ActionContext context = new ActionContext();
                context.setRequestImpl((HttpServletRequest) pageContext.getRequest());
                context.setResponseImpl((HttpServletResponse) pageContext.getResponse());
                context.setServletContextImpl(pageContext.getServletContext());
                ActionContext.setContext(context);
                bundle = ((ActionSupport) ActionFactory.getAction(ActionSupport.class.getName())).getTexts(name);
            }

            getStack().pushValue(new BundleAccessor(bundle));
        }
        catch (Exception e)
        {
            LogFactory.getLog(getClass()).error("Could not find the bundle " + nameAttr, e);
            throw new JspException("Could not find the bundle " + nameAttr);
        }

        return EVAL_BODY_INCLUDE;
    }

    public int doEndTag() throws JspException
    {
        getStack().popValue();
        super.doEndTag();
        return EVAL_PAGE;
    }

    // This is what the text tag will use to access the bundle
    public static class BundleAccessor
    {
        ResourceBundle bundle;

        public BundleAccessor(ResourceBundle aBundle)
        {
            bundle = aBundle;
        }

        public String getText(String aName)
        {
            return bundle.getString(aName);
        }
    }
}


