/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

import webwork.action.ValidationEditorSupport;

/**
 * @author Dick Zetterberg (dick@transitor.se)
 * @version $Revision: 1.1 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 * @see PropertyEditorException
 */
public class FloatObjectEditor extends ValidationEditorSupport implements FastPropertyEditor
{

    public void setAsText(String txt)
    {
        setValue(getAsValue(txt));
    }

    public Object getAsValue(String txt)
    {
        if (txt == null || txt.length() == 0)
        {
            return null;
        }
        try
        {
            return Float.valueOf(txt);
        }
        catch (NumberFormatException e)
        {
            throw new PropertyEditorException(PropertyMessage.BAD_FLOATOBJ, txt);
        }
    }

}

