/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.jdom;

import java.net.URL;
import java.net.MalformedURLException;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.apache.commons.logging.*;
import webwork.util.ClassLoaderUtils;

/**
 * Used to access the RSS file containing the feed sources
 *
 * @author Maurice C. Parker (maurice@vineyardenterprise.com)
 * @version $Revision: 1.4 $
 */
public class RssReader
        extends JDOMUrl
{
    // Attributes ----------------------------------------------------
    Element channel;
    List items;

    // Public --------------------------------------------------------
    public Element getChannel()
    {
        return channel;
    }

    public List getItems()
    {
        return items;
    }

    protected String doExecute()
            throws Exception
    {
        URL xmlUrl;
        try
        {
            //log.info("url="+url);
            xmlUrl = new URL(url);
        }
        catch (MalformedURLException e)
        {
            try
            {
                //try and build the url from request
                xmlUrl = new URL(buildUrl(url));
            }
            catch (MalformedURLException e1)
            {
                // Not a real URL
                // Try as resource
                xmlUrl = ClassLoaderUtils.getResource(url, RssReader.class);
                if (xmlUrl == null)
                {
                    addError("url", "Not a valid URL");
                    return ERROR;
                }
            }
        }

        // Feed it back so that it can be accessed
        String oldUrl = url;
        url = xmlUrl.toString();

        String result;
        try
        {
            // Get document
            result = super.doExecute();
        }
        finally
        {
            // Reset URL
            url = oldUrl;
        }

        // Handle the various versions
        if (document.getRootElement().getName().equals("rss"))
        {
            // RSS 0.91
            channel = document.getRootElement().getChild("channel");
            items = channel.getChildren("item");
        }
        else if (document.getRootElement().getName().equals("rdf"))
        {
            // RDF 1.0
            channel = document.getRootElement().getChild("channel");
            items = document.getRootElement().getChildren("item");
        }

        return result;
    }
}
