/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.events;

import webwork.action.ActionSupport;
import webwork.action.CommandDriven;
import webwork.action.SessionAware;
import webwork.util.BeanUtil;

import java.util.Map;

/**
 * This code is an adaptation of the EventHandler example from the Rocks homepage by Christian Cryder
 * http://xmlc.enhydra.org/EventHandler/
 */
public class Login
        extends ActionSupport
        implements SessionAware, CommandDriven
{
    // Attributes ----------------------------------------------------
    String name = "";
    String password = "";

    Map session;

    boolean autoLogin = false;

    // Public --------------------------------------------------------
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public String getPassword()
    {
        return password;
    }

    public boolean getAutoLogin()
    {
        return autoLogin;
    }

    // SessionAware implementation ------------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // Action implementation ----------------------------------------
    public String execute()
            throws Exception
    {
        // Auto-login?
        if (session.get("login") != null)
        {
            Login login = (Login) session.get("login");
            BeanUtil.copy(login, this);
            autoLogin = true;
            return SUCCESS;
        }

        return super.execute();
    }

    protected String doExecute()
            throws Exception
    {
        // Check login
        if (!password.equals(name))
        {
            addErrorMessage("Wrong password");
            return ERROR;
        }

        // Login
        session.put("login", this);

        return SUCCESS;
    }
}
