/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.dispatcher;

import webwork.action.Action;

import java.util.List;

public class ActionResult
{
    // Attributes ----------------------------------------------------
    private String result;
    private Object view;
    private List actions;
    private Exception actionException;

    // Constructors --------------------------------------------------
    public ActionResult(String result, Object view, List actions, Exception actionException)
    {
        this.result = result;
        this.view = view;
        this.actions = actions;
        this.actionException = actionException;
    }

    public String getResult()
    {
        return result;
    }

    public void setResult(String result)
    {
        this.result = result;
    }

    // Public --------------------------------------------------------
    public Object getView()
    {
        return view;
    }

    public List getActions()
    {
        return actions;
    }

    public Action getFirstAction()
    {
        if (actions == null || actions.size() == 0)
        {
            return null;
        }

        return (Action) actions.get(0);
    }

    public Action getLastAction()
    {
        if (actions == null || actions.size() == 0)
        {
            return null;
        }

        return (Action) actions.get(actions.size() - 1);
    }

    public Exception getActionException()
    {
        return actionException;
    }

    public void setActionException(Exception actionException)
    {
        this.actionException = actionException;
    }
}