package webwork.config.util;

import java.util.List;

/**
 * This returns information about an Action
 */
public interface ActionInfo
{
    /**
     * @return the name of the action
     */
    public String getActionName();

    /**
     * @return the alias of the action
     */
    public String getActionAlias();

    /**
     * @return a list of all the attribute names used when defining the Action
     */
    public List<String> getAttributeNames();

    /**
     * The value of a named attribute or null if its not known about
     *
     * @param attributeName the name of the attribute to return.
     *
     * @return the value of a named attribute or null if its not known about
     */
    public String getAttributeValue(String attributeName);
}
