/*
 * Decompiled with CFR 0.152.
 */
package nz.co.nativemobile.cameramodule.helper;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnz/co/nativemobile/cameramodule/helper/BitmapHelper;", "", "()V", "Companion", "cameramodule_release"})
public final class BitmapHelper {
    private static final String TAG;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        String string = BitmapHelper.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BitmapHelper::class.java.name");
        TAG = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J&\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnz/co/nativemobile/cameramodule/helper/BitmapHelper$Companion;", "", "()V", "TAG", "", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "decodeSampledBitmapFromInputStream", "Landroid/graphics/Bitmap;", "inputStream", "Ljava/io/InputStream;", "bufferedInputStream", "Ljava/io/BufferedInputStream;", "decodeSampledBitmapFromResource", "res", "Landroid/content/res/Resources;", "resId", "cameramodule_release"})
    public static final class Companion {
        @NotNull
        public final Bitmap decodeSampledBitmapFromResource(@NotNull Resources res, int resId, int reqWidth, int reqHeight) {
            Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeResource(res, resId, options)");
            return bitmap;
        }

        @Nullable
        public final Bitmap decodeSampledBitmapFromInputStream(@NotNull InputStream inputStream, @NotNull BufferedInputStream bufferedInputStream, int reqWidth, int reqHeight) {
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            Intrinsics.checkParameterIsNotNull((Object)bufferedInputStream, (String)"bufferedInputStream");
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Rect rect = new Rect(-1, -1, -1, -1);
            BitmapFactory.decodeStream((InputStream)bufferedInputStream, (Rect)rect, (BitmapFactory.Options)options);
            int insampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
            Log.e((String)TAG, (String)("insamplesize is " + insampleSize));
            options.inSampleSize = insampleSize;
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeStream((InputStream)inputStream, (Rect)rect, (BitmapFactory.Options)options);
        }

        private final int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
            int height = options.outHeight;
            int width = options.outWidth;
            int inSampleSize = 1;
            if (height > reqHeight || width > reqWidth) {
                int halfHeight = height / 2;
                int halfWidth = width / 2;
                while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                    inSampleSize *= 2;
                }
            }
            return inSampleSize;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

