/*
 * Decompiled with CFR 0.152.
 */
package nz.co.nativemobile.cameramodule.helper;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnz/co/nativemobile/cameramodule/helper/BitmapHelper;", "", "()V", "Companion", "cameramodule_release"})
public final class BitmapHelper {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lnz/co/nativemobile/cameramodule/helper/BitmapHelper$Companion;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "decodeSampledBitmapFromInputStream", "Landroid/graphics/Bitmap;", "inputStream", "Ljava/io/InputStream;", "bufferedInputStream", "Ljava/io/BufferedInputStream;", "decodeSampledBitmapFromResource", "res", "Landroid/content/res/Resources;", "resId", "cameramodule_release"})
    public static final class Companion {
        @NotNull
        public final Bitmap decodeSampledBitmapFromResource(@NotNull Resources res, int resId, int reqWidth, int reqHeight) {
            Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeResource(res, resId, options)");
            return bitmap;
        }

        @NotNull
        public final Bitmap decodeSampledBitmapFromInputStream(@NotNull InputStream inputStream, @NotNull BufferedInputStream bufferedInputStream, int reqWidth, int reqHeight) {
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            Intrinsics.checkParameterIsNotNull((Object)bufferedInputStream, (String)"bufferedInputStream");
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Rect rect = new Rect(-1, -1, -1, -1);
            BitmapFactory.decodeStream((InputStream)bufferedInputStream, (Rect)rect, (BitmapFactory.Options)options);
            int foo = this.calculateInSampleSize(options, reqWidth, reqHeight);
            Log.e((String)"foo", (String)("insamplesize is " + foo));
            options.inSampleSize = foo;
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, (Rect)rect, (BitmapFactory.Options)options);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeStre\u2026putStream, rect, options)");
            return bitmap;
        }

        private final int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
            int height = options.outHeight;
            int width = options.outWidth;
            int inSampleSize = 1;
            if (height > reqHeight || width > reqWidth) {
                int halfHeight = height / 2;
                int halfWidth = width / 2;
                while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                    inSampleSize *= 2;
                }
            }
            return inSampleSize;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

