package nz.co.nativemobile.cameramodule.extensions

import android.content.Context
import android.os.Environment
import java.io.File
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*

/**
 * Created by wadereweti on 30/06/17.
 */

const val MEDIA_TIME_STAMP = "yyyy-MM-dd_HH:mm.ss"
const val IMAGE_FILE_PREFIX = "IMG_"
const val IMAGE_FILE_SUFFIX = ".jpg"

const val VIDEO_FILE_PREFIX = "IMG_"
const val VIDEO_FILE_SUFFIX = ".mp4"

fun Context.createImageFile(): File {
    val (imageFileName, storageDirectory) = buildMetadata(IMAGE_FILE_PREFIX)

    return createFileWithMediaFileNameAndStorageDirectory(imageFileName, storageDirectory, IMAGE_FILE_SUFFIX)
}

fun Context.createVideoFile(): File {
    val (imageFileName, storageDirectory) = buildMetadata(VIDEO_FILE_PREFIX)

    return createFileWithMediaFileNameAndStorageDirectory(imageFileName, storageDirectory, VIDEO_FILE_SUFFIX)
}

private fun Context.buildMetadata(prefix: String): Pair<String, File> {
    val imageFileName = buildImageFileName(prefix)
    val storageDirectory = getExternalFilesDir(Environment.DIRECTORY_PICTURES)

    return Pair(imageFileName, storageDirectory)
}

private fun buildImageFileName(prefix: String): String = prefix + buildTimeStamp() + "_"

private fun buildTimeStamp(): String? = SimpleDateFormat(MEDIA_TIME_STAMP, Locale.ENGLISH).format(Date())

private fun createFileWithMediaFileNameAndStorageDirectory(imageFileName: String, storageDirectory: File, fileSuffix: String): File {
    var file: File? = null

    try {
        file = File.createTempFile(imageFileName, fileSuffix, storageDirectory)
    } catch (e: IOException) {
        e.printStackTrace()
    }

    return file!!
}