/*
 * Decompiled with CFR 0.152.
 */
package nz.co.nativemobile.cameramodule.extensions;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\n\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\u000f*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0011\u001a\u00020\n*\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\n*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"IMAGE_FILE_PREFIX", "", "IMAGE_FILE_SUFFIX", "MEDIA_TIME_STAMP", "VIDEO_FILE_PREFIX", "VIDEO_FILE_SUFFIX", "buildImageFileName", "prefix", "buildTimeStamp", "createFileWithMediaFileNameAndStorageDirectory", "Ljava/io/File;", "imageFileName", "storageDirectory", "fileSuffix", "buildMetadata", "Lkotlin/Pair;", "Landroid/content/Context;", "createImageFile", "createVideoFile", "cameramodule_release"})
public final class Context_ExtensionKt {
    @NotNull
    public static final String MEDIA_TIME_STAMP = "yyyy-MM-dd_HH:mm.ss";
    @NotNull
    public static final String IMAGE_FILE_PREFIX = "IMG_";
    @NotNull
    public static final String IMAGE_FILE_SUFFIX = ".jpg";
    @NotNull
    public static final String VIDEO_FILE_PREFIX = "IMG_";
    @NotNull
    public static final String VIDEO_FILE_SUFFIX = ".mp4";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File createImageFile(@NotNull Context $receiver) {
        void imageFileName;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Pair<String, File> pair = Context_ExtensionKt.buildMetadata($receiver, "IMG_");
        String string = (String)pair.component1();
        File storageDirectory = (File)pair.component2();
        return Context_ExtensionKt.createFileWithMediaFileNameAndStorageDirectory((String)imageFileName, storageDirectory, IMAGE_FILE_SUFFIX);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File createVideoFile(@NotNull Context $receiver) {
        void imageFileName;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Pair<String, File> pair = Context_ExtensionKt.buildMetadata($receiver, "IMG_");
        String string = (String)pair.component1();
        File storageDirectory = (File)pair.component2();
        return Context_ExtensionKt.createFileWithMediaFileNameAndStorageDirectory((String)imageFileName, storageDirectory, VIDEO_FILE_SUFFIX);
    }

    private static final Pair<String, File> buildMetadata(@NotNull Context $receiver, String prefix) {
        String imageFileName = Context_ExtensionKt.buildImageFileName(prefix);
        File storageDirectory = $receiver.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        return new Pair((Object)imageFileName, (Object)storageDirectory);
    }

    private static final String buildImageFileName(String prefix) {
        return prefix + Context_ExtensionKt.buildTimeStamp() + "_";
    }

    private static final String buildTimeStamp() {
        return new SimpleDateFormat(MEDIA_TIME_STAMP, Locale.ENGLISH).format(new Date());
    }

    private static final File createFileWithMediaFileNameAndStorageDirectory(String imageFileName, File storageDirectory, String fileSuffix) {
        File file = null;
        try {
            file = File.createTempFile(imageFileName, fileSuffix, storageDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file2 = file;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        return file2;
    }
}

