/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.credentials.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nu.studer.java.util.OrderedProperties;
import org.gradle.api.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialsPersistenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsPersistenceManager.class);
    private final File credentialsFile;

    public CredentialsPersistenceManager(File credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public File getCredentialsFile() {
        return new File(this.credentialsFile.toURI());
    }

    public OrderedProperties readCredentials() {
        OrderedProperties credentials = CredentialsPersistenceManager.createOrderedProperties();
        File file = this.getCredentialsFile();
        if (file.exists()) {
            LOGGER.debug("Read existing credentials file: " + file.getAbsolutePath());
            CredentialsPersistenceManager.loadProperties(credentials, file);
        } else {
            LOGGER.debug("Credentials file does not exist yet: " + file.getAbsolutePath());
        }
        return credentials;
    }

    public void storeCredentials(OrderedProperties credentials) {
        File file = this.getCredentialsFile();
        LOGGER.debug("Write updated credentials file: " + file.getAbsolutePath());
        CredentialsPersistenceManager.saveProperties(credentials, file);
    }

    private static void loadProperties(OrderedProperties properties, File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            CredentialsPersistenceManager.loadProperties(properties, inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static void loadProperties(OrderedProperties properties, InputStream stream) {
        try {
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static void saveProperties(OrderedProperties properties, File file) {
        try (FileOutputStream propertiesFileOutputStream = new FileOutputStream(file);){
            properties.store((OutputStream)propertiesFileOutputStream, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static OrderedProperties createOrderedProperties() {
        return new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).build();
    }
}

