/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.databinding.ViewDataBinding;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import nu.annat.beholder.ViewInformation;
import nu.annat.beholder.action.ActionHandler;
import nu.annat.beholder.presenter.ComponentInfo;

public abstract class ComponentViewHolder<BINDING extends ViewDataBinding, PRESENTER extends ComponentInfo>
extends RecyclerView.ViewHolder {
    protected final BINDING binding;
    protected final ActionHandler actionHandler;
    protected final ViewInformation viewInformation;
    private final int layoutId;
    private final int reuseId;
    protected PRESENTER presenter;

    private ComponentViewHolder(View view) {
        super(view);
        this.binding = null;
        this.actionHandler = null;
        this.layoutId = 0;
        this.reuseId = 0;
        this.viewInformation = null;
    }

    public ComponentViewHolder(ViewInformation viewInformation, ViewDataBinding binding, ActionHandler actionHandler, int layoutId, int reuseId) {
        super(binding.getRoot());
        this.layoutId = layoutId;
        this.actionHandler = actionHandler;
        this.reuseId = reuseId;
        this.binding = binding;
        this.viewInformation = viewInformation;
        this.prepareView();
    }

    public PRESENTER getPresenter() {
        return this.presenter;
    }

    public void setData(PRESENTER presenter, boolean force) {
        this.presenter = presenter;
        this.prepareData();
        if (force) {
            this.binding.executePendingBindings();
        }
    }

    protected void prepareView() {
    }

    protected void prepareData() {
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public int getReuseId() {
        return this.reuseId;
    }

    protected void act(Object action) {
        if (this.actionHandler != null) {
            this.actionHandler.handle(action);
        }
    }
}

