/*
 * Decompiled with CFR 0.152.
 */
package nf.fr.eraasoft.pool.impl;

import nf.fr.eraasoft.pool.ObjectPool;
import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObject;
import nf.fr.eraasoft.pool.impl.AbstractPool;
import nf.fr.eraasoft.pool.impl.BlockingQueueObjectPool;
import nf.fr.eraasoft.pool.impl.ConcurrentLinkedQueuePool;
import nf.fr.eraasoft.pool.impl.Controlable;

public class PoolFactory<T> {
    final PoolSettings<T> settings;
    AbstractPool<T> pool;
    final PoolableObject<T> poolableObject;

    public PoolFactory(PoolSettings<T> settings, PoolableObject<T> poolableObject) {
        this.settings = settings;
        this.poolableObject = poolableObject;
    }

    public ObjectPool<T> getPool() {
        if (this.pool == null) {
            this.createPoolInstance();
        }
        return this.pool;
    }

    public void clear() {
        if (this.getPool() instanceof Controlable) {
            ((Controlable)((Object)this.getPool())).clear();
        }
    }

    private synchronized void createPoolInstance() {
        if (this.pool == null) {
            this.pool = this.settings.max() > 0 ? new BBObjectPool<T>(this.poolableObject, this.settings) : new ConcurrentLinkedQueuePool<T>(this.poolableObject, this.settings);
        }
    }

    public PoolSettings<T> settings() {
        return this.settings;
    }

    private static class BBObjectPool<T>
    extends BlockingQueueObjectPool<T> {
        public BBObjectPool(PoolableObject<T> poolableObject, PoolSettings<T> settings) {
            super(poolableObject, settings);
        }
    }
}

