/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import android.os.SystemClock;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000bH\u0000\u001a\u0017\u0010\f\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0080\b\u001a,\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u000e\b\u0004\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00100\rH\u0080\b\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"calculateJobStatus", "", "requestDurationMillis", "", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "computeJobResult", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "block", "Lkotlin/Function1;", "measureRealtimeMillis", "Lkotlin/Function0;", "", "runWithTimeout", "T", "timeout", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "library_release"})
public final class RunnerUtilsKt {
    @NotNull
    public static final JobResult computeJobResult(@NotNull JobType jobType, @NotNull JobRequest jobRequest, @NotNull Function1<? super JobRequest, String> block) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)jobType), (String)"jobType");
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        String responseBody = "";
        int isResponseKnown = 0;
        long start$iv = SystemClock.elapsedRealtime();
        try {
            responseBody = (String)block.invoke((Object)jobRequest);
            isResponseKnown = 1;
        }
        catch (IOException e) {
            responseBody = e.toString();
        }
        catch (Exception e) {
            responseBody = e.toString();
        }
        long requestDurationMillis = SystemClock.elapsedRealtime() - start$iv;
        int n = isResponseKnown;
        if (n == 1) {
            string = RunnerUtilsKt.calculateJobStatus(requestDurationMillis, jobRequest);
        } else if (n == 0) {
            string = "unknown";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String status = string;
        Timber.d((String)("RUNNER: [" + jobRequest + "] => " + status), (Object[])new Object[0]);
        n = 0;
        String string2 = status;
        String string3 = responseBody;
        long l = requestDurationMillis;
        return new JobResult(null, jobType, jobRequest.getExecutionUuid(), string2, l, string3, n, 65, null);
    }

    public static final <T> T runWithTimeout(long timeout, @NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future f2 = executor.submit(new Callable<T>(block){
            final /* synthetic */ Function0 $block;

            public final T call() {
                return (T)this.$block.invoke();
            }
            {
                this.$block = function0;
            }
        });
        return f2.get(timeout, TimeUnit.MILLISECONDS);
    }

    public static final long measureRealtimeMillis(@NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        long start = SystemClock.elapsedRealtime();
        block.invoke();
        return SystemClock.elapsedRealtime() - start;
    }

    @NotNull
    public static final String calculateJobStatus(long requestDurationMillis, @NotNull JobRequest jobRequest) {
        long criticalAfterMillis;
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Long l = jobRequest.getDegradedAfter();
        long degradedAfterMillis = l != null ? l : 1000L;
        Long l2 = jobRequest.getCriticalAfter();
        long l3 = criticalAfterMillis = l2 != null ? l2 : 2000L;
        return requestDurationMillis > degradedAfterMillis ? "degraded" : (requestDurationMillis > criticalAfterMillis ? "critical" : "ok");
    }
}

