/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.RunnerUtilsKt;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.data.runner.UdpRunner;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobRequestKt;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnetwork/path/mobilenode/library/data/runner/UdpRunner;", "Lnetwork/path/mobilenode/library/data/runner/Runner;", "()V", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "getJobType", "()Lnetwork/path/mobilenode/library/domain/entity/JobType;", "runJob", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "runUdpJob", "", "library_release"})
public final class UdpRunner
implements Runner {
    @NotNull
    private final JobType jobType = JobType.UDP;

    @Override
    @NotNull
    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    @NotNull
    public JobResult runJob(@NotNull JobRequest jobRequest, @NotNull TimeSource timeSource) {
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        return RunnerUtilsKt.computeJobResult(this.getJobType(), jobRequest, timeSource, (Function1<? super JobRequest, String>)((Function1)new Function1<JobRequest, String>(this){
            final /* synthetic */ UdpRunner this$0;

            @NotNull
            public final String invoke(@NotNull JobRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                long timeout$iv = 10000L;
                ExecutorService executor$iv = Executors.newSingleThreadExecutor();
                Future<T> f$iv = executor$iv.submit((Callable)new Callable<String>(this, it){
                    final /* synthetic */ runJob.1 this$0;
                    final /* synthetic */ JobRequest $it$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$it$inlined = jobRequest;
                    }

                    public final String call() {
                        return UdpRunner.access$runUdpJob(this.this$0.this$0, this.$it$inlined);
                    }
                });
                return (String)f$iv.get(timeout$iv, TimeUnit.MILLISECONDS);
            }
            {
                this.this$0 = udpRunner;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runUdpJob(JobRequest jobRequest) {
        Closeable closeable = new DatagramSocket();
        Throwable throwable = null;
        try {
            String body;
            DatagramSocket it = (DatagramSocket)closeable;
            int port = JobRequestKt.endpointPortOrDefault(jobRequest, 67);
            InetAddress socketAddress = InetAddress.getByName(JobRequestKt.getEndpointHost(jobRequest));
            String string = jobRequest.getPayload();
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            String string3 = body = string2;
            Charset charset = Charsets.UTF_8;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            int n = port;
            InetAddress inetAddress = socketAddress;
            int n2 = body.length();
            byte[] byArray3 = byArray2;
            DatagramPacket datagramPacket = new DatagramPacket(byArray3, n2, inetAddress, n);
            it.send(datagramPacket);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return "UDP packet sent successfully";
    }

    @NotNull
    public static final /* synthetic */ String access$runUdpJob(UdpRunner $this, @NotNull JobRequest jobRequest) {
        return $this.runUdpJob(jobRequest);
    }
}

