/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.http;

import android.content.Context;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.Constants;
import network.path.mobilenode.library.domain.DomainGenerator;
import network.path.mobilenode.library.domain.PathNativeProcesses;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.utils.Executable;
import network.path.mobilenode.library.utils.GuardedProcessPool;
import network.path.mobilenode.library.utils.SocketExtensionsKt;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnetwork/path/mobilenode/library/data/http/PathNativeProcessesImpl;", "Lnetwork/path/mobilenode/library/domain/PathNativeProcesses;", "context", "Landroid/content/Context;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "(Landroid/content/Context;Lnetwork/path/mobilenode/library/domain/PathStorage;)V", "simpleObfs", "Lnetwork/path/mobilenode/library/utils/GuardedProcessPool;", "ssLocal", "start", "", "stop", "waitFor", "port", "", "delay", "", "Companion", "library_release"})
public final class PathNativeProcessesImpl
implements PathNativeProcesses {
    private final GuardedProcessPool ssLocal;
    private final GuardedProcessPool simpleObfs;
    private final Context context;
    private final PathStorage storage;
    private static final int TIMEOUT = 600;
    private static final int PROXY_PORT = 443;
    private static final String PROXY_PASSWORD = "PathNetwork";
    private static final String PROXY_ENCRYPTION_METHOD = "aes-256-cfb";
    public static final Companion Companion = new Companion(null);

    @Override
    public void start() {
        this.stop();
        String host = DomainGenerator.INSTANCE.findDomain(this.storage);
        if (host != null) {
            Timber.d((String)("NATIVE: found proxy domain [" + host + ']'), (Object[])new Object[0]);
            String libs = this.context.getApplicationInfo().nativeLibraryDir;
            List obfsCmd = CollectionsKt.mutableListOf((Object[])new String[]{new File(libs, "libobfs-local.so").getAbsolutePath(), "-s", host, "-p", String.valueOf(443), "-l", String.valueOf(Constants.INSTANCE.getSIMPLE_OBFS_PORT()), "-t", String.valueOf(600), "--obfs", "http"});
            GuardedProcessPool.start$default(this.simpleObfs, obfsCmd, null, 2, null);
            PathNativeProcessesImpl.waitFor$default(this, Constants.INSTANCE.getSIMPLE_OBFS_PORT(), 0L, 2, null);
            List cmd = CollectionsKt.mutableListOf((Object[])new String[]{new File(libs, "libss-local.so").getAbsolutePath(), "-u", "-s", "127.0.0.1", "-p", String.valueOf(Constants.INSTANCE.getSIMPLE_OBFS_PORT()), "-k", PROXY_PASSWORD, "-m", PROXY_ENCRYPTION_METHOD, "-b", "127.0.0.1", "-l", String.valueOf(Constants.INSTANCE.getSS_LOCAL_PORT()), "-t", String.valueOf(600)});
            GuardedProcessPool.start$default(this.ssLocal, cmd, null, 2, null);
            PathNativeProcessesImpl.waitFor$default(this, Constants.INSTANCE.getSS_LOCAL_PORT(), 0L, 2, null);
        } else {
            Timber.w((String)"NATIVE: proxy domain not found", (Object[])new Object[0]);
        }
    }

    @Override
    public void stop() {
        Timber.d((String)"NATIVE: stopping native processes and scheduled restart thread", (Object[])new Object[0]);
        this.simpleObfs.killAll();
        this.ssLocal.killAll();
        Executable.INSTANCE.killAll(this.context);
    }

    /*
     * WARNING - void declaration
     */
    private final void waitFor(int port, long delay) {
        int n = 1;
        int n2 = 3;
        while (n <= n2 && !SocketExtensionsKt.isPortInUse(port)) {
            void i;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                break;
            }
            ++i;
        }
    }

    static /* synthetic */ void waitFor$default(PathNativeProcessesImpl pathNativeProcessesImpl, int n, long l, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = 100L;
        }
        pathNativeProcessesImpl.waitFor(n, l);
    }

    public PathNativeProcessesImpl(@NotNull Context context, @NotNull PathStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        this.context = context;
        this.storage = storage;
        this.ssLocal = new GuardedProcessPool();
        this.simpleObfs = new GuardedProcessPool();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnetwork/path/mobilenode/library/data/http/PathNativeProcessesImpl$Companion;", "", "()V", "PROXY_ENCRYPTION_METHOD", "", "PROXY_PASSWORD", "PROXY_PORT", "", "TIMEOUT", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

