/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.Constants;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.RunnerUtilsKt;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.data.runner.TraceRunner;
import network.path.mobilenode.library.data.runner.mtr.Mtr;
import network.path.mobilenode.library.data.runner.mtr.MtrResult;
import network.path.mobilenode.library.data.runner.mtr.MtrSummary;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobRequestKt;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lnetwork/path/mobilenode/library/data/runner/TraceRunner;", "Lnetwork/path/mobilenode/library/data/runner/Runner;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "getJobType", "()Lnetwork/path/mobilenode/library/domain/entity/JobType;", "runJob", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "runTraceJob", "Lkotlin/Pair;", "", "", "Companion", "library_release"})
public final class TraceRunner
implements Runner {
    @NotNull
    private final JobType jobType;
    private final Gson gson;
    private static final int MAX_HOPS = 30;
    private static final int PACKET_SIZE = 60;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    @NotNull
    public JobResult runJob(@NotNull JobRequest jobRequest, @NotNull TimeSource timeSource) {
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        return RunnerUtilsKt.computeJobResult(this.getJobType(), jobRequest, timeSource, (Function1<? super JobRequest, Pair<String, Long>>)((Function1)new Function1<JobRequest, Pair<? extends String, ? extends Long>>(this){
            final /* synthetic */ TraceRunner this$0;

            @NotNull
            public final Pair<String, Long> invoke(@NotNull JobRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                long timeout$iv = Constants.INSTANCE.getTRACEROUTE_JOB_TIMEOUT_MILLIS();
                ExecutorService executor$iv = Executors.newSingleThreadExecutor();
                Future<T> f$iv = executor$iv.submit((Callable)new Callable<Pair<? extends String, ? extends Long>>(this, it){
                    final /* synthetic */ runJob.1 this$0;
                    final /* synthetic */ JobRequest $it$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$it$inlined = jobRequest;
                    }

                    public final Pair<? extends String, ? extends Long> call() {
                        return TraceRunner.access$runTraceJob(this.this$0.this$0, this.$it$inlined);
                    }
                });
                return (Pair)f$iv.get(timeout$iv, TimeUnit.MILLISECONDS);
            }
            {
                this.this$0 = traceRunner;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, Long> runTraceJob(JobRequest jobRequest) {
        Pair pair;
        Integer n = jobRequest.getEndpointPort();
        int port = n != null ? n : 0;
        MtrSummary res = new Mtr().trace(JobRequestKt.getEndpointHost(jobRequest), port, false, 30, 60);
        if (res != null) {
            Collection $receiver$iv;
            void initial$iv;
            Iterable $receiver$iv2;
            StringBuilder $receiver$iv$iv;
            Object object;
            MtrResult it;
            Object object2;
            void $receiver$iv$iv2;
            Object grouped;
            Object $receiver$iv22;
            Iterable answer$iv$iv$iv;
            Object key$iv$iv;
            Object it2;
            Object element$iv$iv;
            void $receiver$iv$iv3;
            void $receiver$iv3;
            void $receiver$iv$iv32;
            Iterable $receiver$iv32;
            Iterable iterable = $receiver$iv32 = (Iterable)ArraysKt.filterNotNull((Object[])res.getHops());
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv32) {
                MtrResult it22 = (MtrResult)element$iv$iv2;
                if (!(it22.getTtl() != 0)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $receiver$iv32 = (List)destination$iv$iv;
            $receiver$iv$iv32 = $receiver$iv3;
            destination$iv$iv = new LinkedHashMap();
            Iterator iterator = $receiver$iv$iv3.iterator();
            while (iterator.hasNext()) {
                Object object3;
                Object $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv = iterator.next();
                it2 = (MtrResult)element$iv$iv;
                key$iv$iv = ((MtrResult)it2).getTtl() + ((MtrResult)it2).getIp();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv = $receiver$iv22 = (grouped = destination$iv$iv);
            Iterable destination$iv$iv2 = new ArrayList($receiver$iv22.size());
            element$iv$iv = $receiver$iv$iv2;
            for (Map.Entry entry : element$iv$iv.entrySet()) {
                MtrResult mtrResult;
                void $receiver$iv$iv4;
                key$iv$iv = entry;
                object2 = destination$iv$iv2;
                MtrResult first = (MtrResult)CollectionsKt.first((List)((List)it.getValue()));
                Iterable $receiver$iv4 = (Iterable)it.getValue();
                answer$iv$iv$iv = $receiver$iv4;
                Collection destination$iv$iv3 = new ArrayList();
                for (Object element$iv$iv3 : $receiver$iv$iv4) {
                    MtrResult probe = (MtrResult)element$iv$iv3;
                    if (probe.getTimeout()) continue;
                    destination$iv$iv3.add(element$iv$iv3);
                }
                List filtered = (List)destination$iv$iv3;
                if (filtered.isEmpty()) {
                    mtrResult = first;
                } else {
                    Object v5;
                    Object v3;
                    MtrResult probe;
                    void $receiver$iv$iv5;
                    Iterable $receiver$iv5 = filtered;
                    Iterable $i$f$getOrPut = $receiver$iv5;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
                    for (Object item$iv$iv2 : $receiver$iv$iv5) {
                        MtrResult $i$f$filterNotTo = (MtrResult)item$iv$iv2;
                        Collection collection = destination$iv$iv4;
                        Double d = probe.getDelay();
                        collection.add(d);
                    }
                    double avg = CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv4));
                    Iterable $receiver$iv6 = filtered;
                    Iterator iterator$iv = $receiver$iv6.iterator();
                    if (!iterator$iv.hasNext()) {
                        v3 = null;
                    } else {
                        Object minElem$iv = iterator$iv.next();
                        probe = (MtrResult)minElem$iv;
                        double minValue$iv = probe.getDelay();
                        while (iterator$iv.hasNext()) {
                            Object e$iv = iterator$iv.next();
                            MtrResult probe2 = (MtrResult)e$iv;
                            double v$iv = probe2.getDelay();
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        }
                        v3 = minElem$iv;
                    }
                    MtrResult mtrResult2 = v3;
                    double min = mtrResult2 != null ? mtrResult2.getDelay() : avg;
                    Iterable $receiver$iv7 = filtered;
                    Iterator iterator$iv2 = $receiver$iv7.iterator();
                    if (!iterator$iv2.hasNext()) {
                        v5 = null;
                    } else {
                        Object maxElem$iv = iterator$iv2.next();
                        MtrResult probe3 = (MtrResult)maxElem$iv;
                        double maxValue$iv = probe3.getDelay();
                        while (iterator$iv2.hasNext()) {
                            Object e$iv = iterator$iv2.next();
                            MtrResult probe4 = (MtrResult)e$iv;
                            double v$iv = probe4.getDelay();
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        }
                        v5 = maxElem$iv;
                    }
                    MtrResult mtrResult3 = v5;
                    double max = mtrResult3 != null ? mtrResult3.getDelay() : avg;
                    mtrResult = new MtrResult(first.getTtl(), first.getHost(), first.getIp(), false, avg, min, max, first.getErr());
                }
                object = mtrResult;
                object2.add(object);
            }
            List folded = (List)destination$iv$iv2;
            Iterable $receiver$iv8 = folded;
            destination$iv$iv2 = $receiver$iv8;
            Collection destination$iv$iv5 = new ArrayList();
            it2 = $receiver$iv$iv.iterator();
            while (it2.hasNext()) {
                Object t = it2.next();
                it = (MtrResult)t;
                if (!(!it.getTimeout())) continue;
                destination$iv$iv5.add(t);
            }
            $receiver$iv8 = (List)destination$iv$iv5;
            $receiver$iv$iv = $receiver$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            it2 = $receiver$iv$iv.iterator();
            while (it2.hasNext()) {
                Object t = it2.next();
                it = (MtrResult)t;
                object2 = destination$iv$iv3;
                object = it.getDelay() * (double)1000;
                object2.add(object);
            }
            Double duration = CollectionsKt.max((Iterable)((List)destination$iv$iv3));
            $receiver$iv2 = folded;
            $receiver$iv$iv = new StringBuilder();
            object2 = new StringBuilder().append("TRACE: duration [").append(duration).append("], result [");
            StringBuilder accumulator$iv = initial$iv;
            for (Object t : $receiver$iv2) {
                void r;
                it = (MtrResult)t;
                void sb = accumulator$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)sb.append("\n").append(r), (String)"sb.append(\"\\n\").append(r)");
            }
            object = accumulator$iv;
            Timber.d((String)((StringBuilder)object2).append(object).append(']').toString(), (Object[])new Object[0]);
            Collection thisCollection$iv = $receiver$iv = (Collection)folded;
            MtrResult[] mtrResultArray = thisCollection$iv.toArray(new MtrResult[0]);
            if (mtrResultArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            MtrResult[] mtrResultArray2 = mtrResultArray;
            int n2 = res.getPacketSize();
            int n3 = res.getMaxHops();
            String string = res.getTargetIp();
            String string2 = res.getTarget();
            MtrResult[] mtrResultArray3 = mtrResultArray2;
            MtrSummary summary = new MtrSummary(mtrResultArray3, string2, string, n3, n2);
            Double d = duration;
            pair = TuplesKt.to((Object)this.gson.toJson((Object)summary), (Object)(d != null ? Long.valueOf((long)d.doubleValue()) : null));
        } else {
            pair = TuplesKt.to((Object)"", null);
        }
        return pair;
    }

    public TraceRunner(@NotNull Gson gson) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        this.gson = gson;
        this.jobType = JobType.TRACEROUTE;
    }

    static {
        System.loadLibrary("traceroute");
    }

    @NotNull
    public static final /* synthetic */ Pair access$runTraceJob(TraceRunner $this, @NotNull JobRequest jobRequest) {
        return $this.runTraceJob(jobRequest);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnetwork/path/mobilenode/library/data/runner/TraceRunner$Companion;", "", "()V", "MAX_HOPS", "", "PACKET_SIZE", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

