/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.domain;

import com.instacart.library.truetime.TrueTimeRx;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import network.path.mobilenode.library.domain.PathStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnetwork/path/mobilenode/library/domain/DomainGenerator;", "", "()V", "CHECK_MAX_DAYS", "", "SEED", "", "", "findDomain", "", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "generate", "", "seed", "cal", "Ljava/util/Calendar;", "generateDomains", "resolve", "domain", "library_release"})
public final class DomainGenerator {
    private static final int CHECK_MAX_DAYS = 10;
    private static final List<int[]> SEED;
    public static final DomainGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final Set<String> generateDomains() {
        void $receiver$iv;
        void initial$iv;
        Calendar cal;
        Date date;
        try {
            date = TrueTimeRx.now();
        }
        catch (Exception e) {
            Timber.w((String)("TRUE TIME: now() failed: " + e), (Object[])new Object[0]);
            date = new Date();
        }
        Date date2 = date;
        Calendar calendar = cal = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal");
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(date2);
        Iterable e = SEED;
        Set set = new LinkedHashSet();
        void accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            int[] nArray = (int[])element$iv;
            void set2 = accumulator$iv;
            Iterable $receiver$iv2 = (Iterable)RangesKt.until((int)0, (int)10);
            void accumulator$iv2 = set2;
            Iterator iterator = $receiver$iv2.iterator();
            while (iterator.hasNext()) {
                void seed;
                int element$iv2;
                int n = element$iv2 = ((IntIterator)iterator).nextInt();
                void innerSet = accumulator$iv2;
                Set<String> newSet = INSTANCE.generate((int[])seed, cal);
                innerSet.addAll((Collection)newSet);
                cal.add(6, -1);
                accumulator$iv2 = innerSet;
            }
            accumulator$iv = set2;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> generate(int[] seed, Calendar cal) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        int n = 1;
        Iterable iterable = $receiver$iv = (Iterable)new IntRange(n, 24);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            int n3 = cal.get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)BigInteger.valueOf(n3), (String)"BigInteger.valueOf(this.toLong())");
            int n4 = cal.get(2) + 1;
            Intrinsics.checkExpressionValueIsNotNull((Object)BigInteger.valueOf(n4), (String)"BigInteger.valueOf(this.toLong())");
            int n5 = cal.get(5);
            Intrinsics.checkExpressionValueIsNotNull((Object)BigInteger.valueOf(n5), (String)"BigInteger.valueOf(this.toLong())");
            void var13_18 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)BigInteger.valueOf((long)var13_18), (String)"BigInteger.valueOf(this.toLong())");
            StringBuffer domain = new StringBuffer();
            int n6 = 1;
            int n7 = 16;
            while (n6 <= n7) {
                void i;
                BigInteger v;
                BigInteger bigInteger;
                BigInteger hour;
                BigInteger day;
                BigInteger month;
                BigInteger year;
                BigInteger bigInteger2 = year;
                int n8 = seed[0];
                BigInteger bigInteger3 = BigInteger.valueOf(n8);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger3, (String)"BigInteger.valueOf(this.toLong())");
                BigInteger bigInteger4 = bigInteger3;
                BigInteger bigInteger5 = bigInteger4.multiply(year);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger5, (String)"this.multiply(other)");
                bigInteger4 = bigInteger5;
                BigInteger bigInteger6 = bigInteger2.xor(bigInteger4);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger6, (String)"this.xor(other)");
                bigInteger2 = bigInteger6;
                int n9 = seed[1];
                BigInteger bigInteger7 = bigInteger2.shiftRight(n9);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger7, (String)"this.shiftRight(n)");
                bigInteger2 = bigInteger7;
                BigInteger bigInteger8 = year;
                int n10 = seed[2];
                BigInteger bigInteger9 = bigInteger8.shiftLeft(n10);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger9, (String)"this.shiftLeft(n)");
                bigInteger8 = bigInteger9;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2.xor(bigInteger8), (String)"this.xor(other)");
                bigInteger2 = month;
                int n11 = seed[3];
                BigInteger bigInteger10 = BigInteger.valueOf(n11);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger10, (String)"BigInteger.valueOf(this.toLong())");
                BigInteger bigInteger11 = bigInteger10;
                BigInteger bigInteger12 = bigInteger11.multiply(month);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger12, (String)"this.multiply(other)");
                bigInteger11 = bigInteger12;
                BigInteger bigInteger13 = bigInteger2.xor(bigInteger11);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger13, (String)"this.xor(other)");
                bigInteger2 = bigInteger13;
                int n12 = seed[4];
                BigInteger bigInteger14 = bigInteger2.shiftRight(n12);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger14, (String)"this.shiftRight(n)");
                bigInteger2 = bigInteger14;
                n12 = seed[5];
                BigInteger bigInteger15 = BigInteger.valueOf(n12);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger15, (String)"BigInteger.valueOf(this.toLong())");
                BigInteger bigInteger16 = bigInteger15;
                BigInteger bigInteger17 = bigInteger16.multiply(month);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger17, (String)"this.multiply(other)");
                bigInteger16 = bigInteger17;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2.xor(bigInteger16), (String)"this.xor(other)");
                bigInteger2 = day;
                bigInteger16 = day;
                n10 = seed[6];
                BigInteger bigInteger18 = bigInteger16.shiftLeft(n10);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger18, (String)"this.shiftLeft(n)");
                bigInteger16 = bigInteger18;
                BigInteger bigInteger19 = bigInteger2.xor(bigInteger16);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger19, (String)"this.xor(other)");
                bigInteger2 = bigInteger19;
                int n13 = seed[7];
                BigInteger bigInteger20 = bigInteger2.shiftRight(n13);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger20, (String)"this.shiftRight(n)");
                bigInteger2 = bigInteger20;
                BigInteger bigInteger21 = day;
                n10 = seed[8];
                BigInteger bigInteger22 = bigInteger21.shiftLeft(n10);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger22, (String)"this.shiftLeft(n)");
                bigInteger21 = bigInteger22;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2.xor(bigInteger21), (String)"this.xor(other)");
                bigInteger2 = hour;
                int n14 = seed[9];
                BigInteger bigInteger23 = BigInteger.valueOf(n14);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger23, (String)"BigInteger.valueOf(this.toLong())");
                BigInteger bigInteger24 = bigInteger23;
                BigInteger bigInteger25 = bigInteger24.multiply(hour);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger25, (String)"this.multiply(other)");
                bigInteger24 = bigInteger25;
                BigInteger bigInteger26 = bigInteger2.xor(bigInteger24);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger26, (String)"this.xor(other)");
                bigInteger2 = bigInteger26;
                int n15 = seed[10];
                BigInteger bigInteger27 = bigInteger2.shiftRight(n15);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger27, (String)"this.shiftRight(n)");
                bigInteger2 = bigInteger27;
                n15 = seed[11];
                BigInteger bigInteger28 = BigInteger.valueOf(n15);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger28, (String)"BigInteger.valueOf(this.toLong())");
                BigInteger bigInteger29 = bigInteger28;
                BigInteger bigInteger30 = bigInteger29.multiply(hour);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger30, (String)"this.multiply(other)");
                bigInteger29 = bigInteger30;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2.xor(bigInteger29), (String)"this.xor(other)");
                bigInteger29 = year;
                BigInteger bigInteger31 = bigInteger29.xor(month);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger31, (String)"this.xor(other)");
                bigInteger29 = bigInteger31;
                BigInteger bigInteger32 = bigInteger29.xor(day);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger32, (String)"this.xor(other)");
                bigInteger29 = bigInteger32;
                BigInteger bigInteger33 = bigInteger29.xor(hour);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger33, (String)"this.xor(other)");
                bigInteger29 = bigInteger33;
                n10 = 25;
                Intrinsics.checkExpressionValueIsNotNull((Object)BigInteger.valueOf(n10), (String)"BigInteger.valueOf(this.toLong())");
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger29.remainder(bigInteger), (String)"this.remainder(other)");
                char c = (char)(v.intValue() + 97);
                domain.append(c);
                ++i;
            }
            domain.append(".net");
            String string = domain.toString();
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String findDomain(@NotNull PathStorage storage) {
        void $receiver$iv$iv;
        List result2;
        Collection<Callable> collection;
        void $receiver$iv$iv2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        String saved = storage.getProxyDomain();
        if (saved != null) {
            return saved;
        }
        Set<String> domains = this.generateDomains();
        Timber.d((String)("DOMAIN: potential domains count [" + domains.size() + ']'), (Object[])new Object[0]);
        ExecutorService executor = Executors.newCachedThreadPool();
        Iterable iterable = domains;
        ExecutorService executorService = executor;
        void var7_7 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            Callable callable = new Callable<String>((String)it){
                final /* synthetic */ String $it;

                @Nullable
                public final String call() {
                    return DomainGenerator.access$resolve(DomainGenerator.INSTANCE, this.$it);
                }
                {
                    this.$it = string;
                }
            };
            collection.add(callable);
        }
        collection = (List)destination$iv$iv;
        List list = result2 = executorService.invokeAll((Collection)collection);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"result");
        Iterable $receiver$iv2 = list;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            String string;
            Object element$iv$iv = element$iv$iv$iv;
            Future it = (Future)element$iv$iv;
            if ((String)it.get() == null) continue;
            String it$iv$iv = string;
            destination$iv$iv2.add(it$iv$iv);
        }
        String resolved = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
        Timber.d((String)("DOMAIN: resolved domains [" + resolved + ']'), (Object[])new Object[0]);
        if (resolved != null) {
            storage.setProxyDomain(resolved);
        }
        return resolved;
    }

    private final String resolve(String domain) {
        String string;
        try {
            InetAddress.getAllByName(domain);
            string = domain;
        }
        catch (Exception e) {
            Timber.v((String)("DOMAIN: cannot resolve host [" + domain + "]: " + e), (Object[])new Object[0]);
            string = null;
        }
        return string;
    }

    private DomainGenerator() {
    }

    static {
        DomainGenerator domainGenerator;
        INSTANCE = domainGenerator = new DomainGenerator();
        SEED = CollectionsKt.listOf((Object)new int[]{8, 11, 17, 4, 25, 16, 13, 19, 12, 7, 14, 47});
    }

    @Nullable
    public static final /* synthetic */ String access$resolve(DomainGenerator $this, @NotNull String domain) {
        return $this.resolve(domain);
    }
}

