/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.profile.api.ProfileInfoEndpoint;
import network.minter.profile.models.AddressInfoResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.User;
import retrofit2.Call;

public class ProfileInfoRepository
extends DataRepository<ProfileInfoEndpoint> {
    public ProfileInfoRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<ProfileResult<AddressInfoResult>> getAddressWithUserInfo(String string) {
        return ((ProfileInfoEndpoint)this.getInstantService()).getAddressWithUserInfo(string);
    }

    public Call<ProfileResult<AddressInfoResult>> getAddressWithUserInfo(MinterAddress minterAddress) {
        return this.getAddressWithUserInfo(minterAddress.toString());
    }

    public Call<ProfileResult<List<AddressInfoResult>>> getAddressesWithUserInfoByStrings(List<String> list) {
        return ((ProfileInfoEndpoint)this.getInstantService()).getAddressesWithUserInfo(list);
    }

    public Call<ProfileResult<List<AddressInfoResult>>> getAddressesWithUserInfo(List<MinterAddress> object) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((MinterAddress)object.next()).toString());
        }
        return this.getAddressesWithUserInfoByStrings(arrayList2);
    }

    public Call<ProfileResult<User.Data>> getUserInfoByUsername(String string) {
        return ((ProfileInfoEndpoint)this.getInstantService()).getUserInfoByUsername(string);
    }

    public Call<ProfileResult<User.Data>> getUserInfoByUser(User user) {
        return this.getUserInfoByUser(user.data);
    }

    public Call<ProfileResult<User.Data>> getUserInfoByUser(User.Data data) {
        return this.getUserInfoByUsername(data.username);
    }

    public Call<ProfileResult<AddressInfoResult>> findAddressInfoByInput(@Nonnull String string) {
        String string2 = string;
        Preconditions.checkNotNull((Object)string2, (String)"Input can't be null");
        Preconditions.checkArgument((boolean)(string2.isEmpty() ^ true), (Object)"Input can't be empty string");
        Preconditions.checkArgument((string2.length() >= 2 ? 1 : 0) != 0, (Object)"Input length must have length more than 2 characters");
        if (string.substring(0, 2).equals("Mx") && string.length() == 42) {
            return this.getAddressWithUserInfo(string);
        }
        if (string.substring(0, 1).equals("@")) {
            return ((ProfileInfoEndpoint)this.getInstantService()).findAddressByUsername(string.substring(1));
        }
        return ((ProfileInfoEndpoint)this.getInstantService()).findAddressByEmail(string);
    }

    @Nonnull
    protected Class<ProfileInfoEndpoint> getServiceClass() {
        return ProfileInfoEndpoint.class;
    }
}

