/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.models;

import com.google.gson.annotations.SerializedName;
import java.util.Locale;
import network.minter.profile.MinterProfileApi;
import network.minter.profile.models.ProfileAddressData;
import org.parceler.Parcel;

@Parcel
public class User {
    public Token token;
    @SerializedName(value="user")
    public Data data;

    public User(String authToken) {
        this.token = new Token();
        this.token.tokenType = "advanced";
        this.token.expiresIn = System.currentTimeMillis() / 1000L + 315569260L;
        this.token.accessToken = authToken;
        this.token.refreshToken = null;
        this.data = new Data();
    }

    User() {
    }

    public Data getData() {
        if (this.data == null) {
            this.data = new Data();
        }
        return this.data;
    }

    @Parcel
    public static class Avatar {
        public String src;
        public String description;
        long id = -1L;

        public String getUrl() {
            if (this.id < 0L) {
                return MinterProfileApi.getUserAvatarUrl(1L);
            }
            if (this.src == null && this.id > 0L) {
                return MinterProfileApi.getUserAvatarUrl(this.id);
            }
            return this.src;
        }
    }

    @Parcel
    public static class Data {
        public long id;
        public String username;
        public String name;
        public String email;
        public String phone;
        public String language;
        public Avatar avatar;
        public ProfileAddressData mainAddress;

        public boolean hasAvatar() {
            return this.avatar != null;
        }

        public String getLanguage() {
            if (this.language == null) {
                this.language = "en_US";
            }
            return this.language;
        }

        public String getLanguageDisplay() {
            return new Locale(this.getLanguage()).getDisplayLanguage();
        }

        public Avatar getAvatar() {
            if (this.avatar == null) {
                this.avatar = new Avatar();
            }
            this.avatar.id = this.id;
            return this.avatar;
        }
    }

    @Parcel
    public static class Token {
        public String tokenType;
        public long expiresIn;
        public String accessToken;
        public String refreshToken;
    }
}

