/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import com.google.gson.reflect.TypeToken;
import io.reactivex.Observable;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.helpers.CollectionsHelper;
import network.minter.explorer.api.GateTransactionEndpoint;
import network.minter.explorer.models.GateResult;
import network.minter.explorer.models.PushResult;

public class GateTransactionRepository
extends DataRepository<GateTransactionEndpoint>
implements DataRepository.Configurator {
    public GateTransactionRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<GateResult<PushResult>> sendTransaction(@Nonnull TransactionSign transactionSign) {
        Preconditions.checkArgument((transactionSign != null && transactionSign.getTxSign() != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return ((GateTransactionEndpoint)this.getInstantService()).sendTransaction(CollectionsHelper.asMap((Object[])new String[]{"tx", transactionSign.getTxSign()}));
    }

    @Nonnull
    protected Class<GateTransactionEndpoint> getServiceClass() {
        return GateTransactionEndpoint.class;
    }

    public void configure(ApiService.Builder object) {
        GateResult.Deserializer<PushResult> deserializer;
        ApiService.Builder builder = object;
        Object object2 = new TypeToken<GateResult<PushResult>>(object2){}.getType();
        object = deserializer;
        deserializer = new GateResult.Deserializer<PushResult>(PushResult.class);
        builder.registerTypeAdapter((Type)object2, object);
    }
}

