/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer;

import android.os.Build;
import android.util.Log;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerJsonConverter;
import network.minter.core.internal.api.converters.BytesDataJsonConverter;
import network.minter.core.internal.api.converters.MinterAddressJsonConverter;
import network.minter.core.internal.api.converters.MinterCheckJsonConverter;
import network.minter.core.internal.api.converters.MinterHashJsonConverter;
import network.minter.core.internal.api.converters.MinterPublicKeyJsonConverter;
import network.minter.core.internal.common.Acceptor;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.StdLogger;
import network.minter.core.internal.log.TimberLogger;
import network.minter.explorer.repo.ExplorerAddressRepository;
import network.minter.explorer.repo.ExplorerCoinsRepository;
import network.minter.explorer.repo.ExplorerTransactionRepository;
import network.minter.explorer.repo.ExplorerValidatorsRepository;
import network.minter.explorer.repo.GateCoinRepository;
import network.minter.explorer.repo.GateEstimateRepository;
import network.minter.explorer.repo.GateGasRepository;
import network.minter.explorer.repo.GateTransactionRepository;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class MinterExplorerSDK {
    public static final String FRONT_URL = "https://explorer.testnet.minter.network";
    private static final String BASE_API_URL = "https://explorer-api.testnet.minter.network/api/v2/";
    private static final String BASE_GATE_URL = "https://gate-api.testnet.minter.network/api/v2/";
    private static final String DATE_FORMAT;
    private static MinterExplorerSDK INSTANCE;
    private final ApiService.Builder mApiService;
    private final ApiService.Builder mGateApiService;
    private ExplorerTransactionRepository mTransactionRepository;
    private ExplorerAddressRepository mAddressRepository;
    private ExplorerCoinsRepository mCoinsRepository;
    private ExplorerValidatorsRepository mValidatorsRepository;
    private GateGasRepository mGasRepository;
    private GateEstimateRepository mGateEstimateRepo;
    private GateTransactionRepository mGateTxRepo;
    private GateCoinRepository mGateCoinRepo;

    private MinterExplorerSDK() {
        this(BASE_API_URL, BASE_GATE_URL);
    }

    private MinterExplorerSDK(String object, String string) {
        MinterBlockChainSDK.ResponseErrorToResultInterceptor responseErrorToResultInterceptor;
        Acceptor<Retrofit.Builder> acceptor;
        ApiService.Builder builder;
        MinterBlockChainSDK.ResponseErrorToResultInterceptor responseErrorToResultInterceptor2;
        Acceptor<Retrofit.Builder> acceptor2;
        ApiService.Builder builder2;
        Object object2 = builder2;
        object2((String)object, minterExplorerSDK.getGsonBuilder());
        minterExplorerSDK.mApiService = object2;
        builder2.addHeader("Content-Type", "application/json");
        builder2.addHeader("X-Minter-Client-Name", "MinterAndroid (explorer)");
        builder2.addHeader("X-Minter-Client-Version", "1.0.0");
        object = DATE_FORMAT;
        builder2.setDateFormat((String)object);
        object2 = acceptor2;
        acceptor2 = new Acceptor<Retrofit.Builder>(minterExplorerSDK){

            public void accept(Retrofit.Builder builder) {
                builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io()));
            }
        };
        builder2.setRetrofitClientConfig((Acceptor)object2);
        object2 = responseErrorToResultInterceptor2;
        responseErrorToResultInterceptor2 = new MinterBlockChainSDK.ResponseErrorToResultInterceptor();
        builder2.addHttpInterceptor((Interceptor)object2);
        object2 = builder;
        object2(string, minterExplorerSDK.getGsonBuilder());
        minterExplorerSDK.mGateApiService = object2;
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("X-Minter-Client-Name", "MinterAndroid (gate)");
        builder.addHeader("X-Minter-Client-Version", "1.0.0");
        builder.setDateFormat((String)object);
        object = acceptor;
        acceptor = new Acceptor<Retrofit.Builder>(minterExplorerSDK){

            public void accept(Retrofit.Builder builder) {
                builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io()));
            }
        };
        builder.setRetrofitClientConfig((Acceptor)object);
        MinterExplorerSDK minterExplorerSDK = responseErrorToResultInterceptor;
        responseErrorToResultInterceptor = new MinterBlockChainSDK.ResponseErrorToResultInterceptor();
        builder.addHttpInterceptor((Interceptor)minterExplorerSDK);
    }

    public static HttpUrl.Builder newFrontUrl() {
        return HttpUrl.parse((String)FRONT_URL).newBuilder();
    }

    public static MinterExplorerSDK getInstance() {
        return INSTANCE;
    }

    static {
        String string = "yyyy-MM-dd HH:mm:ssX";
        Class.forName("android.os.Build");
        try {
            if (Build.VERSION.SDK_INT < 24) {
                string = "yyyy-MM-dd HH:mm:ssZ";
            }
        }
        catch (Throwable throwable) {
            DATE_FORMAT = string;
            throw throwable;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        DATE_FORMAT = string;
    }

    public GateGasRepository gas() {
        if (this.mGasRepository == null) {
            this.mGasRepository = new GateGasRepository(this.mGateApiService);
        }
        return this.mGasRepository;
    }

    public GateCoinRepository coinsGate() {
        if (this.mGateCoinRepo == null) {
            this.mGateCoinRepo = new GateCoinRepository(this.mGateApiService);
        }
        return this.mGateCoinRepo;
    }

    public void setNetworkId(String string) {
        this.mApiService.addHeader("X-Minter-Chain-Id", string);
    }

    public GateTransactionRepository transactionsGate() {
        if (this.mGateTxRepo == null) {
            this.mGateTxRepo = new GateTransactionRepository(this.mGateApiService);
        }
        return this.mGateTxRepo;
    }

    public GateEstimateRepository estimate() {
        if (this.mGateEstimateRepo == null) {
            this.mGateEstimateRepo = new GateEstimateRepository(this.mGateApiService);
        }
        return this.mGateEstimateRepo;
    }

    public ExplorerTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new ExplorerTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public ExplorerCoinsRepository coins() {
        if (this.mCoinsRepository == null) {
            this.mCoinsRepository = new ExplorerCoinsRepository(this.mApiService);
        }
        return this.mCoinsRepository;
    }

    public ExplorerValidatorsRepository validators() {
        if (this.mValidatorsRepository == null) {
            this.mValidatorsRepository = new ExplorerValidatorsRepository(this.mApiService);
        }
        return this.mValidatorsRepository;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public ApiService.Builder getGateApiService() {
        return this.mGateApiService;
    }

    public ExplorerAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ExplorerAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public GsonBuilder getGsonBuilder() {
        BytesDataJsonConverter bytesDataJsonConverter;
        BigDecimalJsonConverter bigDecimalJsonConverter;
        BigIntegerJsonConverter bigIntegerJsonConverter;
        MinterCheckJsonConverter minterCheckJsonConverter;
        MinterHashJsonConverter minterHashJsonConverter;
        MinterPublicKeyJsonConverter minterPublicKeyJsonConverter;
        MinterAddressJsonConverter minterAddressJsonConverter;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setDateFormat(DATE_FORMAT);
        Object object = minterAddressJsonConverter;
        minterAddressJsonConverter = new MinterAddressJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterAddress.class, object);
        object = minterPublicKeyJsonConverter;
        minterPublicKeyJsonConverter = new MinterPublicKeyJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterPublicKey.class, object);
        object = minterHashJsonConverter;
        minterHashJsonConverter = new MinterHashJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterHash.class, object);
        object = minterCheckJsonConverter;
        minterCheckJsonConverter = new MinterCheckJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterCheck.class, object);
        object = bigIntegerJsonConverter;
        bigIntegerJsonConverter = new BigIntegerJsonConverter();
        gsonBuilder.registerTypeAdapter(BigInteger.class, object);
        object = bigDecimalJsonConverter;
        bigDecimalJsonConverter = new BigDecimalJsonConverter();
        gsonBuilder.registerTypeAdapter(BigDecimal.class, object);
        object = bytesDataJsonConverter;
        bytesDataJsonConverter = new BytesDataJsonConverter();
        gsonBuilder.registerTypeAdapter(BytesData.class, object);
        return gsonBuilder;
    }

    private static final class BigDecimalJsonConverter
    implements JsonDeserializer<BigDecimal>,
    JsonSerializer<BigDecimal> {
        private BigDecimalJsonConverter() {
        }

        public BigDecimal deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonNull() && jsonElement.isJsonPrimitive()) {
                if (jsonElement.getAsString().isEmpty()) {
                    return new BigDecimal("0").setScale(Transaction.VALUE_MUL_DEC.scale());
                }
                return new BigDecimal(jsonElement.getAsString());
            }
            return new BigDecimal("0");
        }

        public JsonElement serialize(BigDecimal bigDecimal, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(bigDecimal.toPlainString());
        }
    }

    public static class Setup {
        private String mExplorerApiUrl = "https://explorer-api.testnet.minter.network/api/v2/";
        private String mGateApiUrl = "https://gate-api.testnet.minter.network/api/v2/";
        private boolean mDebug = false;
        private Mint.Leaf mLogger = null;
        private String mNetId = null;

        public Setup setLogger(Mint.Leaf leaf) {
            this.mLogger = leaf;
            return this;
        }

        public Setup setEnableDebug(boolean bl) {
            this.mDebug = bl;
            return this;
        }

        public Setup setExplorerApiUrl(@Nonnull String string) {
            this.mExplorerApiUrl = string;
            return this;
        }

        public Setup setGateApiUrl(@Nonnull String string) {
            this.mGateApiUrl = string;
            return this;
        }

        public Setup setNetId(String string) {
            this.mNetId = string;
            return this;
        }

        public MinterExplorerSDK init() {
            block8: {
                boolean bl;
                block9: {
                    Setup setup = this;
                    String string = setup.mExplorerApiUrl;
                    INSTANCE = new MinterExplorerSDK(string, setup.mGateApiUrl);
                    INSTANCE.mApiService.setDebug(this.mDebug);
                    INSTANCE.mGateApiService.setDebug(this.mDebug);
                    if (this.mNetId != null) {
                        INSTANCE.mApiService.addHeader("X-Minter-Chain-Id", this.mNetId);
                        INSTANCE.mGateApiService.addHeader("X-Minter-Chain-Id", this.mNetId);
                    }
                    if (!this.mDebug) break block8;
                    bl = true;
                    try {
                        Class.forName("android.util.Log");
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    try {
                        Log.d((String)"test", (String)"test");
                    }
                    catch (RuntimeException runtimeException) {}
                    break block9;
                    {
                    }
                    bl = false;
                }
                if (!bl && this.mLogger instanceof TimberLogger) {
                    Mint.brew((Mint.Leaf)new StdLogger());
                } else {
                    Mint.brew((Mint.Leaf)this.mLogger);
                }
                INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
                INSTANCE.mGateApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
            }
            return MinterExplorerSDK.getInstance();
        }
    }
}

