/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.annimon.stream.Optional;
import com.annimon.stream.Stream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import network.minter.core.crypto.MinterAddress;
import network.minter.explorer.models.CoinBalance;
import org.parceler.Parcel;

@Parcel
public class AddressBalance {
    public Map<String, CoinBalance> coins;
    public MinterAddress address;
    public BigDecimal totalBalance;
    public BigDecimal totalBalanceUSD;
    public BigDecimal availableBalanceBIP;
    public BigDecimal availableBalanceUSD;

    public AddressBalance() {
        HashMap hashMap;
        AddressBalance addressBalance = object;
        Object object = hashMap;
        hashMap = new HashMap();
        addressBalance.coins = object;
        addressBalance.address = null;
        object = BigDecimal.ZERO;
        addressBalance.totalBalance = object;
        addressBalance.totalBalanceUSD = object;
        addressBalance.availableBalanceBIP = object;
        addressBalance.availableBalanceUSD = object;
        addressBalance.fillDefaultsOnEmpty();
    }

    public AddressBalance(MinterAddress minterAddress) {
        HashMap hashMap;
        AddressBalance addressBalance = object;
        Object object = hashMap;
        hashMap = new HashMap();
        addressBalance.coins = object;
        addressBalance.address = null;
        object = BigDecimal.ZERO;
        addressBalance.totalBalance = object;
        addressBalance.totalBalanceUSD = object;
        addressBalance.availableBalanceBIP = object;
        addressBalance.availableBalanceUSD = object;
        addressBalance.address = minterAddress;
        addressBalance.fillDefaultsOnEmpty();
    }

    public void fillDefaultsOnEmpty() {
        if (((AddressBalance)((Object)bigDecimal)).coins.isEmpty()) {
            CoinBalance coinBalance;
            CoinBalance coinBalance2 = coinBalance;
            AddressBalance addressBalance = bigDecimal;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            MinterAddress minterAddress = addressBalance.address;
            Object object = bigDecimal;
            coinBalance = new CoinBalance("MNT", (BigDecimal)object, (BigDecimal)object, minterAddress);
            ((AddressBalance)((Object)bigDecimal)).coins.put("MNT", coinBalance2);
        }
    }

    public boolean isEmpty() {
        return this.coins.isEmpty();
    }

    public int size() {
        return this.coins.size();
    }

    public List<CoinBalance> getCoinsList() {
        return Stream.of(this.coins.values()).toList();
    }

    public Optional<CoinBalance> findCoinByName(String string) {
        if (string == null) {
            return Optional.empty();
        }
        return Stream.of(this.getCoinsList()).filter(coinBalance -> string.toUpperCase().equals(coinBalance.coin.toUpperCase())).findFirst();
    }

    public boolean hasCoin(String string) {
        if (string == null) {
            return false;
        }
        return this.coins.containsKey(string) && this.coins.get(string) != null;
    }

    public CoinBalance getCoin(String string) {
        if (!((AddressBalance)((Object)bigDecimal)).hasCoin(string)) {
            AddressBalance addressBalance = bigDecimal;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            MinterAddress minterAddress = addressBalance.address;
            BigDecimal bigDecimal2 = bigDecimal;
            return new CoinBalance(string, bigDecimal2, bigDecimal2, minterAddress);
        }
        return ((AddressBalance)((Object)bigDecimal)).coins.get(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AddressBalance)) {
            return false;
        }
        object = (AddressBalance)object;
        if (!this.coins.equals(((AddressBalance)object).coins)) {
            return false;
        }
        MinterAddress minterAddress = this.address;
        if (minterAddress != null ? !minterAddress.equals((Object)((AddressBalance)object).address) : ((AddressBalance)object).address != null) {
            return false;
        }
        if (!this.totalBalance.equals(((AddressBalance)object).totalBalance)) {
            return false;
        }
        if (!this.totalBalanceUSD.equals(((AddressBalance)object).totalBalanceUSD)) {
            return false;
        }
        if (!this.availableBalanceBIP.equals(((AddressBalance)object).availableBalanceBIP)) {
            return false;
        }
        return this.availableBalanceUSD.equals(((AddressBalance)object).availableBalanceUSD);
    }

    public int hashCode() {
        AddressBalance addressBalance = this;
        int n = addressBalance.coins.hashCode() * 31;
        MinterAddress minterAddress = addressBalance.address;
        int n2 = minterAddress != null ? minterAddress.hashCode() : 0;
        return ((((n + n2) * 31 + this.totalBalance.hashCode()) * 31 + this.totalBalanceUSD.hashCode()) * 31 + this.availableBalanceBIP.hashCode()) * 31 + this.availableBalanceUSD.hashCode();
    }
}

