/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.GateEstimateEndpoint;
import network.minter.explorer.models.GateResult;
import network.minter.explorer.models.TxCount;
import retrofit2.Call;

public class GateEstimateRepository
extends DataRepository<GateEstimateEndpoint> {
    public GateEstimateRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String string, BigDecimal bigDecimal, @Nonnull String string2) {
        return this.getCoinExchangeCurrencyToSell(string, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), string2);
    }

    public Call<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String string, BigInteger bigInteger, @Nonnull String string2) {
        return ((GateEstimateEndpoint)this.getInstantService()).getCoinExchangeCurrencyToSell(((String)Preconditions.checkNotNull((Object)string, (String)"Source coin required")).toUpperCase(), bigInteger.toString(), ((String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required")).toUpperCase());
    }

    public Call<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String string, BigDecimal bigDecimal, @Nonnull String string2) {
        return this.getCoinExchangeCurrencyToBuy(string, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), string2);
    }

    public Call<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String string, BigInteger bigInteger, @Nonnull String string2) {
        return ((GateEstimateEndpoint)this.getInstantService()).getCoinExchangeCurrencyToBuy(((String)Preconditions.checkNotNull((Object)string, (String)"Source coin required")).toUpperCase(), bigInteger.toString(), ((String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required")).toUpperCase());
    }

    public Call<GateResult<TransactionCommissionValue>> getTransactionCommission(TransactionSign transactionSign) {
        Preconditions.checkArgument((transactionSign != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return this.getTransactionCommission(transactionSign.getTxSign());
    }

    public Call<GateResult<TransactionCommissionValue>> getTransactionCommission(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return ((GateEstimateEndpoint)this.getInstantService()).getTxCommission(string);
    }

    public Call<GateResult<TxCount>> getTransactionCount(@Nonnull MinterAddress minterAddress) {
        Preconditions.checkArgument((minterAddress != null ? 1 : 0) != 0, (Object)"Address can't be null");
        return this.getTransactionCount(minterAddress.toString());
    }

    public Call<GateResult<TxCount>> getTransactionCount(@Nonnull String string) {
        return ((GateEstimateEndpoint)this.getInstantService()).getTransactionsCount((String)Preconditions.checkNotNull((Object)string, (String)"Address required!"));
    }

    @Nonnull
    protected Class<GateEstimateEndpoint> getServiceClass() {
        return GateEstimateEndpoint.class;
    }
}

