/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerAddressEndpoint;
import network.minter.explorer.api.converters.ExplorerAddressDataDeserializer;
import network.minter.explorer.models.AddressData;
import network.minter.explorer.models.BCExplorerResult;
import network.minter.explorer.models.DelegationInfo;
import network.minter.explorer.models.ExpResult;
import retrofit2.Call;

public class ExplorerAddressRepository
extends DataRepository<ExplorerAddressEndpoint>
implements DataRepository.Configurator {
    public ExplorerAddressRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<BCExplorerResult<List<AddressData>>> getAddressesData(List<MinterAddress> object) {
        ArrayList<String> arrayList;
        List<MinterAddress> list = object;
        Preconditions.checkNotNull(list, (String)"List can't be null");
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"List can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            MinterAddress minterAddress = (MinterAddress)object.next();
            if (minterAddress == null) continue;
            arrayList2.add(minterAddress.toString());
        }
        Preconditions.checkArgument((arrayList2.size() > 0 ? 1 : 0) != 0, (Object)"List contains all null items");
        ExplorerAddressRepository explorerAddressRepository = this;
        return ((ExplorerAddressEndpoint)explorerAddressRepository.getInstantService(explorerAddressRepository)).balanceMultiple(arrayList2);
    }

    public Call<BCExplorerResult<AddressData>> getAddressData(MinterAddress minterAddress) {
        return this.getAddressData(minterAddress.toString());
    }

    public Call<BCExplorerResult<AddressData>> getAddressData(String string) {
        return ((ExplorerAddressEndpoint)this.getInstantService()).balance(string);
    }

    public Call<ExpResult<List<DelegationInfo>>> getDelegations(MinterAddress minterAddress) {
        Preconditions.checkNotNull((Object)minterAddress, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getDelegationsForAddress(minterAddress.toString());
    }

    @Nonnull
    protected Class<ExplorerAddressEndpoint> getServiceClass() {
        return ExplorerAddressEndpoint.class;
    }

    public void configure(ApiService.Builder builder) {
        ExplorerAddressDataDeserializer explorerAddressDataDeserializer;
        Object object = explorerAddressDataDeserializer;
        explorerAddressDataDeserializer = new ExplorerAddressDataDeserializer();
        builder.registerTypeAdapter(AddressData.class, object);
    }
}

