/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.api.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import network.minter.core.crypto.MinterAddress;
import network.minter.explorer.models.AddressData;

public class ExplorerAddressDataDeserializer
implements JsonDeserializer<AddressData> {
    private static final String COINS_BALANCE = "balances";

    public AddressData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        AddressData data = new AddressData();
        JsonObject root = json.getAsJsonObject();
        if (root.has("address") && !root.get("address").isJsonNull()) {
            data.address = new MinterAddress((CharSequence)root.get("address").getAsString());
        }
        if (root.has(COINS_BALANCE)) {
            JsonArray coins = root.getAsJsonArray(COINS_BALANCE);
            HashMap<String, AddressData.CoinBalance> out = new HashMap<String, AddressData.CoinBalance>();
            for (int i = 0; i < coins.size(); ++i) {
                JsonObject coin = coins.get(i).getAsJsonObject();
                AddressData.CoinBalance b = new AddressData.CoinBalance();
                b.amount = coin.get("amount").getAsBigDecimal();
                b.coin = coin.get("coin").getAsString();
                out.put(b.coin, b);
            }
            data.coins = out;
        }
        return data;
    }
}

