/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import android.support.annotation.NonNull;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerAddressEndpoint;
import network.minter.explorer.models.AddressData;
import network.minter.explorer.models.BalanceChannel;
import network.minter.explorer.models.ExpResult;
import retrofit2.Call;

public class ExplorerAddressRepository
extends DataRepository<ExplorerAddressEndpoint>
implements DataRepository.Configurator {
    private static final String COINS_BALANCE = "coins";

    public ExplorerAddressRepository(@NonNull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ExpResult<List<AddressData>>> getAddressesData(List<MinterAddress> addresses) {
        ArrayList<String> sAddresses = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            sAddresses.add(address.toString());
        }
        return ((ExplorerAddressEndpoint)this.getInstantService(this)).balanceMultiple(sAddresses);
    }

    public Call<ExpResult<AddressData>> getAddressData(MinterAddress address) {
        return this.getAddressData(address.toString());
    }

    public Call<ExpResult<AddressData>> getAddressData(String address) {
        return ((ExplorerAddressEndpoint)this.getInstantService()).balance(address);
    }

    @NonNull
    protected Class<ExplorerAddressEndpoint> getServiceClass() {
        return ExplorerAddressEndpoint.class;
    }

    public Call<ExpResult<BalanceChannel>> getBalanceChannel(@NonNull List<MinterAddress> addresses, String userId) {
        Preconditions.checkNotNull(addresses, (String)"Addresses can't be null");
        ArrayList<String> addressStrings = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            addressStrings.add(address.toString());
        }
        if (userId == null) {
            return ((ExplorerAddressEndpoint)this.getInstantService()).getBalanceChannel(addressStrings);
        }
        return ((ExplorerAddressEndpoint)this.getInstantService()).getBalanceChannel(addressStrings, userId);
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(AddressData.class, (Object)new AddressDataDeserializer());
    }

    public static class AddressDataDeserializer
    implements JsonDeserializer<AddressData> {
        public AddressData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            AddressData data = new AddressData();
            JsonObject root = json.getAsJsonObject();
            if (root.has(ExplorerAddressRepository.COINS_BALANCE)) {
                JsonArray coins = root.getAsJsonArray(ExplorerAddressRepository.COINS_BALANCE);
                HashMap<String, AddressData.CoinBalance> out = new HashMap<String, AddressData.CoinBalance>();
                for (int i = 0; i < coins.size(); ++i) {
                    JsonObject coin = coins.get(i).getAsJsonObject();
                    AddressData.CoinBalance b = new AddressData.CoinBalance();
                    b.amount = coin.get("amount").getAsBigDecimal();
                    b.usdAmount = coin.get("usdAmount").getAsBigDecimal();
                    b.baseCoinAmount = coin.get("baseCoinAmount").getAsBigDecimal();
                    b.coin = coin.get("coin").getAsString();
                    out.put(b.coin, b);
                }
                data.coins = out;
            }
            data.txCount = root.has("txCount") ? root.get("txCount").getAsLong() : 0L;
            return data;
        }
    }
}

