/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import android.support.annotation.NonNull;
import com.annimon.stream.Objects;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;
import org.parceler.Transient;

@Parcel
public class HistoryTransaction
implements Serializable,
Comparable<HistoryTransaction> {
    public BigInteger txn;
    public MinterHash hash;
    public BigInteger nonce;
    public BigInteger block;
    public Date timestamp;
    public BigDecimal fee;
    public Type type;
    @Transient
    public Object data;
    public Status status;
    public String payload;
    public transient String username;
    public transient String avatarUrl;

    public boolean isIncoming(List<MinterAddress> addressList) {
        if (this.type != Type.Send) {
            return false;
        }
        return addressList.contains(((TxSendCoinResult)this.getData()).to);
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public String getAvatar() {
        return this.avatarUrl;
    }

    public HistoryTransaction setAvatar(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    public HistoryTransaction setUsername(String username) {
        this.username = username;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryTransaction that = (HistoryTransaction)o;
        return this.block.equals(that.block) && Objects.equals((Object)this.fee, (Object)that.fee) && Objects.equals((Object)this.hash, (Object)that.hash) && Objects.equals((Object)this.nonce, (Object)that.nonce) && Objects.equals((Object)this.timestamp, (Object)that.timestamp) && Objects.equals((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equals((Object)this.data, (Object)that.data);
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.hash, this.nonce, this.block, this.timestamp, this.fee, this.type, this.data});
    }

    @Override
    public int compareTo(@NonNull HistoryTransaction o) {
        return o.timestamp.compareTo(this.timestamp);
    }

    @Parcel
    public static class TxRedeemCheckResult {
        public MinterAddress from;
        @SerializedName(value="raw_check")
        public MinterCheck rawCheck;
        public BytesData proof;
    }

    @Parcel
    public static class TxDelegateResult {
        public MinterAddress from;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public String stake;

        public String getCoin() {
            return this.coin.toUpperCase();
        }

        public BigDecimal getStake() {
            if (this.stake == null || this.stake.isEmpty()) {
                this.stake = "0";
            }
            return new BigDecimal(this.stake);
        }
    }

    @Parcel
    public static class TxUnboundResult {
        public MinterAddress from;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public String stake;

        public BigDecimal getStake() {
            if (this.stake == null || this.stake.isEmpty()) {
                this.stake = "0";
            }
            return new BigDecimal(this.stake);
        }

        public String getCoin() {
            return this.coin.toUpperCase();
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult {
        public MinterAddress from;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;
    }

    @Parcel
    public static class TxDeclareCandidacyResult {
        public MinterAddress from;
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;
        public BigDecimal commission;
        public String coin;
        public BigDecimal stake;

        public MinterAddress getFrom() {
            return this.from;
        }

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPubKey() {
            return this.pubKey;
        }

        public BigDecimal getCommission() {
            return this.commission;
        }

        public String getCoin() {
            if (this.coin == null) {
                return null;
            }
            return this.coin.toUpperCase();
        }

        public BigDecimal getStake() {
            return this.stake;
        }
    }

    @Parcel
    public static class TxConvertCoinResult {
        public MinterAddress from;
        @SerializedName(value="coin_to_sell")
        public String coinToSell;
        @SerializedName(value="coin_to_buy")
        public String coinToBuy;
        @SerializedName(value="value")
        public BigDecimal amount;
        @SerializedName(value="value_to_buy")
        public BigDecimal valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigDecimal valueToSell;

        public MinterAddress getFrom() {
            return this.from;
        }

        public String getCoinToSell() {
            if (this.coinToSell == null) {
                return null;
            }
            return this.coinToSell.toUpperCase();
        }

        public String getCoinToBuy() {
            if (this.coinToBuy == null) {
                return null;
            }
            return this.coinToBuy.toUpperCase();
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    public static class TxCreateResult {
        public MinterAddress from;
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigDecimal initialAmount;
        @SerializedName(value="initial_reserve")
        public BigDecimal initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public BigDecimal constantReserveRatio;

        public MinterAddress getFrom() {
            return this.from;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            if (this.symbol == null) {
                return null;
            }
            return this.symbol.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return this.initialAmount;
        }

        public BigDecimal getInitialReserve() {
            return this.initialReserve;
        }

        public BigDecimal getConstantReserveRatio() {
            return this.constantReserveRatio;
        }
    }

    public static class TxSendCoinResult {
        public MinterAddress from;
        public MinterAddress to;
        public String coin;
        public BigDecimal amount;

        public MinterAddress getFrom() {
            return this.from;
        }

        public MinterAddress getTo() {
            return this.to;
        }

        public String getCoin() {
            if (this.coin == null) {
                return null;
            }
            return this.coin.toUpperCase();
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    public static class TxDefaultResult {
        public MinterAddress from;
    }

    public static enum Type {
        Send(TxSendCoinResult.class),
        SellCoin(TxConvertCoinResult.class),
        SellAllCoins(TxConvertCoinResult.class),
        BuyCoin(TxConvertCoinResult.class),
        CreateCoin(TxCreateResult.class),
        DeclareCandidacy(TxDeclareCandidacyResult.class),
        Delegate(TxDelegateResult.class),
        Unbound(TxUnboundResult.class),
        RedeemCheck(TxRedeemCheckResult.class),
        SetCandidateOnline(TxSetCandidateOnlineOfflineResult.class),
        SetCandidateOffline(TxSetCandidateOnlineOfflineResult.class);

        Class<?> mCls;

        private Type(Class<?> cls) {
            this.mCls = cls;
        }

        public Class<?> getCls() {
            return this.mCls;
        }
    }

    public static enum Status {
        Success,
        Error;

    }
}

