/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCoinSellAll
extends Operation {
    public static final Parcelable.Creator<TxCoinSellAll> CREATOR = new Parcelable.Creator<TxCoinSellAll>(){

        public TxCoinSellAll createFromParcel(Parcel parcel) {
            return new TxCoinSellAll(parcel);
        }

        public TxCoinSellAll[] newArray(int n) {
            return new TxCoinSellAll[n];
        }
    };
    private BigInteger mCoinIdToSell;
    private BigInteger mCoinIdToBuy;
    private BigInteger mMinValueToBuy;

    public TxCoinSellAll() {
    }

    public TxCoinSellAll(Transaction transaction) {
        super(transaction);
    }

    protected TxCoinSellAll(Parcel parcel) {
        super(parcel);
        this.mCoinIdToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mCoinIdToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mMinValueToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCoinSellAll txCoinSellAll = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txCoinSellAll.mCoinIdToSell);
        parcel.writeValue((Object)this.mCoinIdToBuy);
        parcel.writeValue((Object)this.mMinValueToBuy);
    }

    public BigInteger getCoinIdToSell() {
        return this.mCoinIdToSell;
    }

    public TxCoinSellAll setCoinIdToSell(BigInteger bigInteger) {
        this.mCoinIdToSell = bigInteger;
        return this;
    }

    public TxCoinSellAll setCoinIdToSell(long l) {
        return this.setCoinIdToSell(BigInteger.valueOf(l));
    }

    public BigInteger getCoinIdToBuy() {
        return this.mCoinIdToBuy;
    }

    public TxCoinSellAll setCoinIdToBuy(BigInteger bigInteger) {
        this.mCoinIdToBuy = bigInteger;
        return this;
    }

    public TxCoinSellAll setCoinIdToBuy(long l) {
        return this.setCoinIdToBuy(BigInteger.valueOf(l));
    }

    public BigInteger getMinValueToBuyBigInteger() {
        return this.mMinValueToBuy;
    }

    public BigDecimal getMinValueToBuy() {
        return Transaction.humanizeValue(this.mMinValueToBuy);
    }

    public TxCoinSellAll setMinValueToBuy(BigInteger bigInteger) {
        this.mMinValueToBuy = bigInteger;
        return this;
    }

    public TxCoinSellAll setMinValueToBuy(BigDecimal bigDecimal) {
        return this.setMinValueToBuy(Transaction.normalizeValue(bigDecimal));
    }

    public TxCoinSellAll setMinValueToBuy(@Nonnull CharSequence charSequence) {
        return this.setMinValueToBuy(new BigDecimal(charSequence.toString()));
    }

    @Override
    public OperationType getType() {
        return OperationType.SellAllCoins;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoinToBuy";
        boolean bl = ((TxCoinSellAll)((Object)fieldsValidationResult2)).mCoinIdToBuy != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin to buy must be set");
        string = "mCoinToSell";
        bl = ((TxCoinSellAll)((Object)fieldsValidationResult2)).mCoinIdToSell != null;
        TxCoinSellAll txCoinSellAll = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Coin to sell must be set");
        object = "mMinValueToBuy";
        boolean bl2 = txCoinSellAll.mMinValueToBuy != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Minimum value to buy must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoinIdToSell;
        objectArray2[1] = this.mCoinIdToBuy;
        objectArray[2] = this.mMinValueToBuy;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mCoinIdToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mCoinIdToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mMinValueToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(2, objectArray3));
    }
}

