/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.List;
import network.minter.blockchain.models.NodeResult;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class EventList
extends NodeResult {
    @SerializedName(value="events")
    public List<EventItem> events;

    @Parcel
    public static class SlashEvent
    extends BaseEvent {
        @SerializedName(value="coin")
        public String coin;
    }

    @Parcel
    public static class RewardEvent
    extends BaseEvent {
        @SerializedName(value="role")
        public String role;
    }

    @Parcel
    public static class BaseEvent {
        @SerializedName(value="address")
        public MinterAddress address;
        @SerializedName(value="amount")
        public BigInteger amount;
        @SerializedName(value="validator_pub_key")
        public MinterPublicKey validatorPublicKey;
    }

    @Parcel
    public static class EventItem {
        public Type type;
        public BaseEvent value;

        public <T extends BaseEvent> T getValue() {
            return (T)this.value;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Reward;
        public static final /* enum */ Type Slash;
        private static final /* synthetic */ Type[] $VALUES;
        private final String mName;
        private final Class<? extends BaseEvent> mCls;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(String string2, Class<? extends BaseEvent> clazz) {
            this.mName = string2;
            this.mCls = clazz;
        }

        public static Type findByName(String string) {
            for (Type type : Type.values()) {
                if (!type.getEventName().toLowerCase().equals(string.toLowerCase())) continue;
                return type;
            }
            return null;
        }

        static {
            Type type;
            Type type2;
            Type type3 = type2;
            Reward = new Type("minter/RewardEvent", RewardEvent.class);
            Type type4 = type;
            Slash = new Type("minter/SlashEvent", SlashEvent.class);
            $VALUES = new Type[]{type3, type4};
        }

        public Class<? extends BaseEvent> getCls() {
            return this.mCls;
        }

        public String getEventName() {
            return this.mName;
        }
    }
}

