package network.minter.blockchain.samples.transactions;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.HistoryTransaction;
import network.minter.blockchain.models.HistoryTransactionList;
import network.minter.blockchain.repo.NodeTransactionRepository;

public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeTransactionRepository repository = MinterBlockChainSDK.getInstance().transactions();


        Observable<HistoryTransactionList> request = repository.getTransactions(
                new NodeTransactionRepository.TQuery()
                        .setFrom("Mx...")
                        .setTo("Mx...")
        );

        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    for (HistoryTransaction tx : result.items) {
                        // handle result
                    }
                }, err -> {
                    // handle error
                });
    }
}
