/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import io.reactivex.Observable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.NodeCoinEndpoint;
import network.minter.blockchain.models.Coin;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;

public class NodeCoinRepository
extends DataRepository<NodeCoinEndpoint> {
    public NodeCoinRepository(ApiService.Builder builder) {
        super(builder);
    }

    public Observable<Coin> getCoinInfo(String string) {
        return ((NodeCoinEndpoint)this.getInstantService()).getCoinInformation((String)Preconditions.checkNotNull((Object)string, (String)"Symbol required"));
    }

    public Observable<Coin> getCoinInfoById(BigInteger bigInteger) {
        return ((NodeCoinEndpoint)this.getInstantService()).getCoinInformationById(((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Symbol required")).toString());
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSell(String string, BigDecimal bigDecimal, String string2) {
        return this.getCoinExchangeCurrencyToSell(string, Transaction.normalizeValue(bigDecimal), string2);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSell(String string, BigInteger object, String string2) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object2.getInstantService();
        Object object2 = (String)Preconditions.checkNotNull((Object)string, (String)"Source coin required");
        string = ((BigInteger)object).toString();
        object = (String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required");
        return nodeCoinEndpoint.getCoinExchangeCurrencyToSell((String)object2, string, (String)object);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSellById(BigInteger bigInteger, BigDecimal bigDecimal, BigInteger bigInteger2) {
        return this.getCoinExchangeCurrencyToSellById(bigInteger, Transaction.normalizeValue(bigDecimal), bigInteger2);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSellById(BigInteger object, BigInteger object2, BigInteger bigInteger) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object3.getInstantService();
        Object object3 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Target coin required")).toString();
        return nodeCoinEndpoint.getCoinExchangeCurrencyToSellById((String)object3, (String)object, (String)object2);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSellAll(String string, BigInteger object, String string2) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object2.getInstantService();
        Object object2 = (String)Preconditions.checkNotNull((Object)string, (String)"Source coin required");
        string = ((BigInteger)object).toString();
        object = (String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required");
        return nodeCoinEndpoint.getCoinExchangeCurrencyToSellAll((String)object2, string, (String)object, null, null);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSellAll(BigInteger object, BigInteger object2, BigInteger bigInteger) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object3.getInstantService();
        Object object3 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Target coin required")).toString();
        return nodeCoinEndpoint.getCoinExchangeCurrencyToSellAllById((String)object3, (String)object, (String)object2, null, null);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSellAll(BigInteger object, BigInteger object2, BigInteger object3, BigInteger bigInteger) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object4.getInstantService();
        Object object4 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)object3, (String)"Target coin required")).toString();
        object3 = bigInteger.toString();
        return nodeCoinEndpoint.getCoinExchangeCurrencyToSellAllById((String)object4, (String)object, (String)object2, (String)object3, null);
    }

    public Observable<ExchangeSellValue> getCoinExchangeCurrencyToSellAll(BigInteger object, BigInteger object2, BigInteger object3, BigInteger object4, BigInteger bigInteger) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object5.getInstantService();
        Object object5 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)object3, (String)"Target coin required")).toString();
        object3 = ((BigInteger)Preconditions.checkNotNull((Object)object4, (String)"Gas price can't be null")).toString();
        object4 = ((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Block number can't be null")).toString();
        return nodeCoinEndpoint.getCoinExchangeCurrencyToSellAllById((String)object5, (String)object, (String)object2, (String)object3, (String)object4);
    }

    public Observable<ExchangeBuyValue> getCoinExchangeCurrencyToBuy(String string, BigDecimal bigDecimal, String string2) {
        return this.getCoinExchangeCurrencyToBuy(string, Transaction.normalizeValue(bigDecimal), string2);
    }

    public Observable<ExchangeBuyValue> getCoinExchangeCurrencyToBuy(String string, BigInteger object, String string2) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object2.getInstantService();
        Object object2 = (String)Preconditions.checkNotNull((Object)string, (String)"Source coin required");
        string = ((BigInteger)object).toString();
        object = (String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required");
        return nodeCoinEndpoint.getCoinExchangeCurrencyToBuy((String)object2, string, (String)object);
    }

    public Observable<ExchangeBuyValue> getCoinExchangeCurrencyToBuyById(BigInteger bigInteger, BigDecimal bigDecimal, BigInteger bigInteger2) {
        return this.getCoinExchangeCurrencyToBuyById(bigInteger, Transaction.normalizeValue(bigDecimal), bigInteger2);
    }

    public Observable<ExchangeBuyValue> getCoinExchangeCurrencyToBuyById(BigInteger object, BigInteger object2, BigInteger bigInteger) {
        NodeCoinEndpoint nodeCoinEndpoint = (NodeCoinEndpoint)object3.getInstantService();
        Object object3 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Target coin required")).toString();
        return nodeCoinEndpoint.getCoinExchangeCurrencyToBuyById((String)object3, (String)object, (String)object2);
    }

    @Nonnull
    protected Class<NodeCoinEndpoint> getServiceClass() {
        return NodeCoinEndpoint.class;
    }
}

