/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxCreateMultisigAddress;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxEditCandidate;
import network.minter.blockchain.models.operational.TxEditCandidatePublicKey;
import network.minter.blockchain.models.operational.TxEditCoinOwner;
import network.minter.blockchain.models.operational.TxEditMultisig;
import network.minter.blockchain.models.operational.TxMultisend;
import network.minter.blockchain.models.operational.TxPriceVote;
import network.minter.blockchain.models.operational.TxRecreateCoin;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxSetHaltBlock;
import network.minter.blockchain.models.operational.TxUnbound;

public final class OperationType
extends Enum<OperationType> {
    @SerializedName(value="1")
    public static final /* enum */ OperationType SendCoin;
    @SerializedName(value="2")
    public static final /* enum */ OperationType SellCoin;
    @SerializedName(value="3")
    public static final /* enum */ OperationType SellAllCoins;
    @SerializedName(value="4")
    public static final /* enum */ OperationType BuyCoin;
    @SerializedName(value="5")
    public static final /* enum */ OperationType CreateCoin;
    @SerializedName(value="6")
    public static final /* enum */ OperationType DeclareCandidacy;
    @SerializedName(value="7")
    public static final /* enum */ OperationType Delegate;
    @SerializedName(value="8")
    public static final /* enum */ OperationType Unbound;
    @SerializedName(value="9")
    public static final /* enum */ OperationType RedeemCheck;
    @SerializedName(value="10")
    public static final /* enum */ OperationType SetCandidateOnline;
    @SerializedName(value="11")
    public static final /* enum */ OperationType SetCandidateOffline;
    @SerializedName(value="12")
    public static final /* enum */ OperationType CreateMultisigAddress;
    @SerializedName(value="13")
    public static final /* enum */ OperationType Multisend;
    @SerializedName(value="14")
    public static final /* enum */ OperationType EditCandidate;
    @SerializedName(value="15")
    public static final /* enum */ OperationType SetHaltBlock;
    @SerializedName(value="16")
    public static final /* enum */ OperationType RecreateCoin;
    @SerializedName(value="17")
    public static final /* enum */ OperationType EditCoinOwner;
    @SerializedName(value="18")
    public static final /* enum */ OperationType EditMultisig;
    @SerializedName(value="19")
    public static final /* enum */ OperationType PriceVote;
    @SerializedName(value="20")
    public static final /* enum */ OperationType EditCandidatePublicKey;
    private static final String FEE_BASE_STRING = "0.001";
    public static final BigDecimal FEE_BASE;
    private static final /* synthetic */ OperationType[] $VALUES;
    final BigInteger mValue;
    Class<? extends Operation> mOpClass;
    BigDecimal mFee;

    public static OperationType[] values() {
        return (OperationType[])$VALUES.clone();
    }

    public static OperationType valueOf(String string) {
        return Enum.valueOf(OperationType.class, string);
    }

    private OperationType(byte by, Class<? extends Operation> clazz, double d) {
        this.mValue = new BigInteger(String.valueOf(by));
        this.mOpClass = clazz;
        this.mFee = this.getFeeBase().multiply(new BigDecimal(String.valueOf(d)));
    }

    @Nullable
    public static OperationType findByValue(BigInteger bigInteger) {
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.mValue.equals(bigInteger)) continue;
            return operationType;
        }
        return null;
    }

    @Nullable
    public static OperationType findByOpClass(Class<? extends Operation> clazz) {
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.getOpClass().equals(clazz)) continue;
            return operationType;
        }
        return null;
    }

    static {
        OperationType operationType;
        OperationType operationType2;
        OperationType operationType3;
        OperationType operationType4;
        OperationType operationType5;
        OperationType operationType6;
        OperationType operationType7;
        OperationType operationType8;
        OperationType operationType9;
        OperationType operationType10;
        OperationType operationType11;
        OperationType operationType12;
        OperationType operationType13;
        OperationType operationType14;
        OperationType operationType15;
        OperationType operationType16;
        OperationType operationType17;
        OperationType operationType18;
        OperationType operationType19;
        OperationType operationType20;
        OperationType operationType21 = operationType20;
        SendCoin = new OperationType(1, TxSendCoin.class, 10.0);
        OperationType operationType22 = operationType19;
        SellCoin = new OperationType(2, TxCoinSell.class, 100.0);
        OperationType operationType23 = operationType18;
        SellAllCoins = new OperationType(3, TxCoinSellAll.class, 100.0);
        OperationType operationType24 = operationType17;
        BuyCoin = new OperationType(4, TxCoinBuy.class, 100.0);
        OperationType operationType25 = operationType16;
        CreateCoin = new OperationType(5, TxCreateCoin.class, 1000.0);
        OperationType operationType26 = operationType15;
        DeclareCandidacy = new OperationType(6, TxDeclareCandidacy.class, 10000.0);
        OperationType operationType27 = operationType14;
        Delegate = new OperationType(7, TxDelegate.class, 200.0);
        OperationType operationType28 = operationType13;
        Unbound = new OperationType(8, TxUnbound.class, 200.0);
        OperationType operationType29 = operationType12;
        RedeemCheck = new OperationType(9, TxRedeemCheck.class, 30.0);
        OperationType operationType30 = operationType11;
        SetCandidateOnline = new OperationType(10, TxSetCandidateOnline.class, 100.0);
        OperationType operationType31 = operationType10;
        SetCandidateOffline = new OperationType(11, TxSetCandidateOffline.class, 100.0);
        OperationType operationType32 = operationType9;
        CreateMultisigAddress = new OperationType(12, TxCreateMultisigAddress.class, 100.0);
        OperationType operationType33 = operationType8;
        Multisend = new OperationType(13, TxMultisend.class, 0.0);
        OperationType operationType34 = operationType7;
        EditCandidate = new OperationType(14, TxEditCandidate.class, 10000.0);
        OperationType operationType35 = operationType6;
        SetHaltBlock = new OperationType(15, TxSetHaltBlock.class, 1000.0);
        OperationType operationType36 = operationType5;
        RecreateCoin = new OperationType(16, TxRecreateCoin.class, 1.0E7);
        OperationType operationType37 = operationType4;
        EditCoinOwner = new OperationType(17, TxEditCoinOwner.class, 1.0E7);
        OperationType operationType38 = operationType3;
        EditMultisig = new OperationType(18, TxEditMultisig.class, 1000.0);
        OperationType operationType39 = operationType2;
        PriceVote = new OperationType(19, TxPriceVote.class, 10.0);
        OperationType operationType40 = operationType;
        EditCandidatePublicKey = new OperationType(20, TxEditCandidatePublicKey.class, 1.0E7);
        $VALUES = new OperationType[]{operationType21, operationType22, operationType23, operationType24, operationType25, operationType26, operationType27, operationType28, operationType29, operationType30, operationType31, operationType32, operationType33, operationType34, operationType35, operationType36, operationType37, operationType38, operationType39, operationType40};
        FEE_BASE = new BigDecimal(FEE_BASE_STRING);
    }

    public BigDecimal getFeeBase() {
        return new BigDecimal(FEE_BASE_STRING);
    }

    public BigDecimal getFee() {
        return this.mFee;
    }

    public Class<? extends Operation> getOpClass() {
        return this.mOpClass;
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public int getValueInt() {
        return this.mValue.intValue();
    }
}

